/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ListAttributeDefinition
extends AttributeDefinition {
    private final ParameterValidator elementValidator;

    public ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator) {
        this(name, name, allowNull, 0, Integer.MAX_VALUE, elementValidator, null, null, new AttributeAccess.Flag[0]);
    }

    public ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator, AttributeAccess.Flag ... flags) {
        this(name, name, allowNull, 0, Integer.MAX_VALUE, elementValidator, null, null, flags);
    }

    public ListAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator) {
        this(name, xmlName, allowNull, minSize, maxSize, elementValidator, null, null, new AttributeAccess.Flag[0]);
    }

    public ListAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        super(name, xmlName, null, ModelType.LIST, allowNull, false, null, new ListValidator(elementValidator, allowNull, minSize, maxSize), alternatives, requires, flags);
        this.elementValidator = elementValidator;
    }

    public ModelNode parse(String value, Location location) throws XMLStreamException {
        String trimmed = value == null ? null : value.trim();
        ModelNode node = trimmed != null ? new ModelNode().set(trimmed) : new ModelNode();
        try {
            this.elementValidator.validateParameter(this.getXmlName(), node);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), location);
        }
        return node;
    }

    public void parseAndAddParameterElement(String value, ModelNode operation, Location location) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, location);
        operation.get(this.getName()).add(paramVal);
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    protected abstract void addValueTypeDescription(ModelNode var1, ResourceBundle var2);

    protected abstract void addAttributeValueTypeDescription(ModelNode var1, ResourceDescriptionResolver var2, Locale var3, ResourceBundle var4);

    protected abstract void addOperationParameterValueTypeDescription(ModelNode var1, String var2, ResourceDescriptionResolver var3, Locale var4, ResourceBundle var5);
}

