/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit.container;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestRunner
implements TestRunner {
    protected List<RunListener> getRunListeners() {
        return Collections.emptyList();
    }

    public TestResult execute(Class<?> testClass, String methodName) {
        TestResult testResult = TestResult.passed();
        ExpectedExceptionHolder exceptionHolder = new ExpectedExceptionHolder();
        try {
            JUnitCore runner = new JUnitCore();
            runner.addListener((RunListener)exceptionHolder);
            for (RunListener listener : this.getRunListeners()) {
                runner.addListener(listener);
            }
            Result result = runner.run(Request.method(testClass, (String)methodName));
            testResult = result.getFailureCount() > 0 ? TestResult.failed((Throwable)exceptionHolder.getException()) : (result.getIgnoreCount() > 0 ? TestResult.skipped(null) : TestResult.passed());
            if (testResult.getThrowable() == null) {
                testResult.setThrowable(exceptionHolder.getException());
            }
        }
        catch (Throwable th) {
            testResult = TestResult.failed((Throwable)th);
        }
        if (testResult.getThrowable() instanceof AssumptionViolatedException) {
            testResult = TestResult.skipped((Throwable)testResult.getThrowable());
        }
        testResult.setEnd(System.currentTimeMillis());
        return testResult;
    }

    private class ExpectedExceptionHolder
    extends RunListener {
        private Throwable exception;

        private ExpectedExceptionHolder() {
        }

        public Throwable getException() {
            return this.exception;
        }

        public void testAssumptionFailure(Failure failure) {
            this.exception = new AssumptionViolatedException(failure.getException().getMessage());
            this.exception.setStackTrace(failure.getException().getStackTrace());
        }

        public void testFailure(Failure failure) throws Exception {
            this.exception = State.getTestException();
            Test test = (Test)failure.getDescription().getAnnotation(Test.class);
            if ((test == null || test.expected() == Test.None.class) && this.exception == null) {
                this.exception = failure.getException();
            }
        }

        public void testFinished(Description description) throws Exception {
            Test test = (Test)description.getAnnotation(Test.class);
            if (test != null && test.expected() != Test.None.class && this.exception == null) {
                this.exception = State.getTestException();
            }
            State.caughtTestException(null);
        }
    }
}

