/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder.screenshooter.browser.impl;

import org.arquillian.extension.recorder.DefaultFileNameBuilder;
import org.arquillian.extension.recorder.ResourceMetaData;
import org.arquillian.extension.recorder.ResourceType;
import org.arquillian.extension.recorder.When;
import org.arquillian.extension.recorder.screenshooter.Screenshooter;
import org.arquillian.extension.recorder.screenshooter.ScreenshooterConfiguration;
import org.arquillian.extension.recorder.screenshooter.ScreenshotMetaData;
import org.arquillian.extension.recorder.screenshooter.api.Screenshot;
import org.arquillian.extension.recorder.screenshooter.browser.configuration.BrowserScreenshooterConfiguration;
import org.arquillian.extension.recorder.screenshooter.browser.impl.InterceptorRegistry;
import org.arquillian.extension.recorder.screenshooter.browser.impl.ResourceIdentifierFactory;
import org.arquillian.extension.recorder.screenshooter.browser.impl.TakeScreenshotAndReportService;
import org.arquillian.extension.recorder.screenshooter.browser.impl.TakeScreenshotOnEveryActionInterceptor;
import org.arquillian.extension.recorder.screenshooter.event.TakeScreenshot;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;

public class ScreenshotTaker {
    @Inject
    private Instance<ScreenshooterConfiguration> configuration;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<InterceptorRegistry> interceptorRegistry;
    @Inject
    private Instance<Screenshooter> screenshooter;

    public void registerOnEveryActionInterceptor(@Observes Before event) {
        BrowserScreenshooterConfiguration configuration = (BrowserScreenshooterConfiguration)((Object)this.configuration.get());
        Screenshot annotation = event.getTestMethod().getAnnotation(Screenshot.class);
        if (annotation != null && annotation.takeOnEveryAction() || annotation == null && configuration.getTakeOnEveryAction()) {
            this.registerInterceptor(event);
        }
    }

    public void onTakeScreenshot(@Observes TakeScreenshot event) {
        DefaultFileNameBuilder nameBuilder = new DefaultFileNameBuilder();
        String screenshotName = nameBuilder.withMetaData((ResourceMetaData)event.getMetaData()).withStage(event.getWhen()).withResourceIdentifier(ResourceIdentifierFactory.getResoruceIdentifier((ResourceMetaData)event.getMetaData(), event.getWhen())).build();
        event.setFileName(screenshotName);
        this.getTakeAndReportService().takeScreenshotAndReport(event);
    }

    public void unregisterInterceptors(@Observes(precedence=-2147483648) After event) {
        InterceptorRegistry registry = (InterceptorRegistry)this.interceptorRegistry.get();
        registry.unregisterAll();
    }

    private TakeScreenshotAndReportService getTakeAndReportService() {
        return (TakeScreenshotAndReportService)((ServiceLoader)this.serviceLoader.get()).onlyOne(TakeScreenshotAndReportService.class);
    }

    private ScreenshotMetaData getMetaData(Before event) {
        ScreenshotMetaData metaData = new ScreenshotMetaData();
        metaData.setTestClass(event.getTestClass());
        metaData.setTestMethod(event.getTestMethod());
        metaData.setTimeStamp(System.currentTimeMillis());
        metaData.setResourceType((ResourceType)((Screenshooter)this.screenshooter.get()).getScreenshotType());
        return metaData;
    }

    private String getScreenshotName(ScreenshotMetaData metaData, When when) {
        DefaultFileNameBuilder nameBuilder = new DefaultFileNameBuilder();
        return nameBuilder.withMetaData((ResourceMetaData)metaData).withStage(when).build();
    }

    private void registerInterceptor(Before event) {
        ScreenshotMetaData metaData = this.getMetaData(event);
        String screenshotName = this.getScreenshotName(metaData, When.ON_EVERY_ACTION);
        Screenshot annotation = event.getTestMethod().getAnnotation(Screenshot.class);
        TakeScreenshot takeScreenshot = new TakeScreenshot(screenshotName, metaData, When.ON_EVERY_ACTION, annotation);
        TakeScreenshotOnEveryActionInterceptor onEveryActionInterceptor = new TakeScreenshotOnEveryActionInterceptor(takeScreenshot, this.getTakeAndReportService(), (InterceptorRegistry)this.interceptorRegistry.get());
        ((InterceptorRegistry)this.interceptorRegistry.get()).register(onEveryActionInterceptor);
    }
}

