/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration.legacy;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.configuration.legacy.LegacyMapping;
import org.jboss.arquillian.drone.configuration.mapping.StringValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.ValueMapper;

public class LegacyConfigurationMapper {
    private static final Logger log = Logger.getLogger(LegacyConfigurationMapper.class.getName());
    private static final Map<String, LegacyMapping> LEGACY_MAP = new HashMap<String, LegacyMapping>();

    public static boolean isLegacy(String propertyName) {
        return LEGACY_MAP.containsKey(propertyName);
    }

    private static boolean remapsToProperty(String propertyName) {
        LegacyMapping mapping = LEGACY_MAP.get(propertyName);
        if (mapping == null) {
            throw new IllegalStateException("Legacy mapping for property name " + propertyName + " is not defined.");
        }
        return mapping.remapsToProperty();
    }

    public static boolean remapsToCapability(String propertyName) {
        return !LegacyConfigurationMapper.remapsToProperty(propertyName);
    }

    public static String remapKey(String propertyKey) {
        if (LegacyConfigurationMapper.isLegacy(propertyKey)) {
            return LEGACY_MAP.get(propertyKey).remapKey(propertyKey);
        }
        return propertyKey;
    }

    public static String remapValue(String propertyKey, String propertyValue) {
        if (LegacyConfigurationMapper.isLegacy(propertyValue)) {
            return LEGACY_MAP.get(propertyKey).remapValue(propertyValue);
        }
        return propertyValue;
    }

    private static class LoggingCapabilityMapping
    extends DefaultCapabilityMapping {
        private final String loggingMessage;

        LoggingCapabilityMapping(String capabilityName, ValueMapper<?> mapper, String loggingMessage) {
            super(capabilityName, mapper);
            this.loggingMessage = loggingMessage;
        }

        @Override
        public String remapValue(String value) {
            log.log(Level.WARNING, this.loggingMessage);
            return super.remapValue(value);
        }
    }

    private static class DefaultCapabilityMapping
    implements LegacyMapping {
        private final String capabilityName;
        private final ValueMapper<?> mapper;

        DefaultCapabilityMapping(String capabilityName) {
            this(capabilityName, StringValueMapper.INSTANCE);
        }

        DefaultCapabilityMapping(String capabilityName, ValueMapper<?> mapper) {
            this.capabilityName = capabilityName;
            this.mapper = mapper;
        }

        @Override
        public boolean remapsToCapability() {
            return true;
        }

        @Override
        public boolean remapsToProperty() {
            return !this.remapsToCapability();
        }

        @Override
        public String remapKey(String fieldName) {
            log.log(Level.WARNING, "Configuration property \"{0}\" is deprecated, please replace it with capability based property \"{1}\" instead.", new Object[]{fieldName, this.capabilityName});
            return this.capabilityName;
        }

        @Override
        public String remapValue(String value) {
            return this.mapper.transform(value).toString();
        }
    }

    private static class FieldMapping
    implements LegacyMapping {
        private final String fieldName;
        private final ValueMapper<?> mapper;

        FieldMapping(String fieldName) {
            this(fieldName, StringValueMapper.INSTANCE);
        }

        FieldMapping(String fieldName, ValueMapper<?> mapper) {
            this.fieldName = fieldName;
            this.mapper = mapper;
        }

        @Override
        public boolean remapsToProperty() {
            return true;
        }

        @Override
        public boolean remapsToCapability() {
            return !this.remapsToProperty();
        }

        @Override
        public String remapKey(String oldFieldName) {
            log.log(Level.WARNING, "Configuration property \"{0}\" is deprecated, please replace it with property \"{1}\" instead.", new Object[]{oldFieldName, this.fieldName});
            return this.fieldName;
        }

        @Override
        public String remapValue(String value) {
            return this.mapper.transform(value).toString();
        }
    }
}

