/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.inject.spi.Extension;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.MockEjBServices;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.MockSecurityServices;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.MockTransactionServices;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.MockValidationServices;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.ServiceLoader;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.Utils;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.validation.spi.ValidationServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployment
implements Deployment {
    private final Collection<BeanDeploymentArchive> beanDeploymentArchives;
    private final ServiceRegistry services = new SimpleServiceRegistry();
    private final Iterable<Metadata<Extension>> extensions;

    public AbstractDeployment(Collection<BeanDeploymentArchive> beanDeploymentArchives, Iterable<Metadata<Extension>> extensions) {
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>(beanDeploymentArchives);
        this.extensions = extensions;
        this.configureServices();
    }

    public AbstractDeployment(BeanDeploymentArchive ... beanDeploymentArchives) {
        this(Arrays.asList(beanDeploymentArchives), ServiceLoader.load(Extension.class));
    }

    public AbstractDeployment(BeanDeploymentArchive beanDeploymentArchive, Extension ... extensions) {
        this(Collections.singleton(beanDeploymentArchive), AbstractDeployment.transform(extensions));
    }

    protected void configureServices() {
        this.services.add(TransactionServices.class, (Service)new MockTransactionServices());
        this.services.add(SecurityServices.class, (Service)new MockSecurityServices());
        this.services.add(EjbServices.class, (Service)new MockEjBServices());
        if (Utils.isClassAccessible("javax.validation.Validator", AbstractDeployment.class.getClassLoader())) {
            this.services.add(ValidationServices.class, (Service)new MockValidationServices());
        }
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return this.extensions;
    }

    public static Iterable<Metadata<Extension>> transform(Extension ... extensions) {
        ArrayList<Metadata<Extension>> result = new ArrayList<Metadata<Extension>>();
        for (final Extension extension : extensions) {
            result.add(new Metadata<Extension>(){

                public String getLocation() {
                    return "unknown";
                }

                public Extension getValue() {
                    return extension;
                }
            });
        }
        return result;
    }
}

