/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.session.Dialect;
import org.javers.repository.sql.session.Dialects;
import org.javers.repository.sql.session.KeyGenerator;
import org.javers.repository.sql.session.Session;

public class SessionFactory {
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;
    private final KeyGenerator keyGenerator;

    public SessionFactory(DialectName dialectName, ConnectionProvider connectionProvider) {
        this.dialect = Dialects.fromName(dialectName);
        this.connectionProvider = connectionProvider;
        this.keyGenerator = this.dialect.getKeyGeneratorDefinition().createKeyGenerator();
    }

    public Session create(String sessionName) {
        return new Session(this.dialect, this.keyGenerator, this.connectionProvider, sessionName);
    }

    public void resetKeyGeneratorCache() {
        this.keyGenerator.reset();
    }
}

