/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GatewayServicesManagementCheck
extends AbstractAction {
    @NotNull
    private final ServicesManager servicesManager;

    public GatewayServicesManagementCheck(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        boolean match = this.servicesManager.matchesExistingService((Service)service);
        if (match) {
            return this.success();
        }
        throw new UnauthorizedServiceException(String.format("Service [%s] is not authorized to use CAS.", service.getId()));
    }
}

