/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.maven.plugin.MojoExecutionException;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.ExecFileLoader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.maven.AbstractJacocoMojo;
import org.jacoco.maven.BundleCreator;
import org.jacoco.maven.CheckConfiguration;
import org.jacoco.maven.FileFilter;

public class CheckMojo
extends AbstractJacocoMojo {
    private static final String MSG_SKIPPING = "Skipping JaCoCo execution due to missing execution data file";
    private static final String ERROR_UNABLE_TO_READ = "Unable to read execution data file %s: %s";
    private static final String ERROR_CHECKING_COVERAGE = "Error while checking coverage: %s";
    private static final String INSUFFICIENT_COVERAGE = "Insufficient code coverage for %s: %2$.2f%% < %3$.2f%%";
    private static final String CHECK_FAILED = "Coverage checks have not been met. See report for details.";
    private static final String CHECK_SUCCESS = "All coverage checks have been met.";
    private CheckConfiguration check;
    private boolean haltOnFailure;
    private File dataFile;
    private ExecutionDataStore executionDataStore;

    private boolean canCheckCoverage() {
        if (!this.dataFile.exists()) {
            this.getLog().info((CharSequence)MSG_SKIPPING);
            return false;
        }
        return true;
    }

    public void executeMojo() throws MojoExecutionException, MojoExecutionException {
        if (!this.canCheckCoverage()) {
            return;
        }
        this.executeCheck();
    }

    private void executeCheck() throws MojoExecutionException {
        try {
            this.loadExecutionData();
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format(ERROR_UNABLE_TO_READ, this.dataFile, e.getMessage()), (Exception)e);
        }
        try {
            if (this.check()) {
                this.getLog().info((CharSequence)CHECK_SUCCESS);
            } else {
                this.handleFailure();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format(ERROR_CHECKING_COVERAGE, e.getMessage()), (Exception)e);
        }
    }

    private void loadExecutionData() throws IOException {
        ExecFileLoader loader = new ExecFileLoader();
        loader.load(this.dataFile);
        this.executionDataStore = loader.getExecutionDataStore();
    }

    private boolean check() throws IOException {
        FileFilter fileFilter = new FileFilter(this.getIncludes(), this.getExcludes());
        BundleCreator creator = new BundleCreator(this.getProject(), fileFilter);
        IBundleCoverage bundle = creator.createBundle(this.executionDataStore);
        boolean passed = true;
        for (ICoverageNode.CounterEntity entity : ICoverageNode.CounterEntity.values()) {
            passed = this.checkCounter(entity, bundle.getCounter(entity), this.check.getRatio(entity)) && passed;
        }
        return passed;
    }

    private boolean checkCounter(ICoverageNode.CounterEntity entity, ICounter counter, double checkRatio) {
        boolean passed = true;
        double ratio = counter.getCoveredRatio() * 100.0;
        if (ratio < checkRatio) {
            this.getLog().warn((CharSequence)String.format(INSUFFICIENT_COVERAGE, entity.name(), this.truncate(ratio), this.truncate(checkRatio)));
            passed = false;
        }
        return passed;
    }

    private BigDecimal truncate(double value) {
        return new BigDecimal(value).setScale(2, 3);
    }

    private void handleFailure() throws MojoExecutionException {
        if (this.haltOnFailure) {
            throw new MojoExecutionException(CHECK_FAILED);
        }
        this.getLog().warn((CharSequence)CHECK_FAILED);
    }
}

