/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.InternalEntryFactoryImpl;
import org.infinispan.eviction.EvictionType;
import org.infinispan.eviction.impl.ActivationManagerStub;
import org.infinispan.eviction.impl.PassivationManagerStub;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.EmbeddedTimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(testName="stress.DataContainerStressTest", groups={"stress"}, description="Disabled by default, designed to be run manually.", timeOut=900000L)
public class DataContainerStressTest {
    volatile CountDownLatch latch;
    final int RUN_TIME_MILLIS = 45000;
    final int WARMUP_TIME_MILLIS = 10000;
    final int num_loops = 10000;
    final int warmup_num_loops = 10000;
    boolean use_time = true;
    final int NUM_KEYS = 256;
    private static final Log log = LogFactory.getLog(DataContainerStressTest.class);

    public void testSimpleDataContainer() throws InterruptedException {
        DefaultDataContainer dc = DefaultDataContainer.unBoundedDataContainer((int)5000);
        this.initializeDefaultDataContainer(dc);
        this.doTest((DataContainer)dc);
    }

    public void testEntryBoundedDataContainer() throws InterruptedException {
        DefaultDataContainer dc = DefaultDataContainer.boundedDataContainer((int)5000, (long)192L, (EvictionType)EvictionType.COUNT);
        this.initializeDefaultDataContainer(dc);
        this.doTest((DataContainer)dc);
    }

    public void testMemoryBoundedDataContainer() throws InterruptedException {
        DefaultDataContainer dc = DefaultDataContainer.boundedDataContainer((int)5000, (long)this.threeQuarterMemorySize(256, 5, 20), (EvictionType)EvictionType.MEMORY);
        this.initializeDefaultDataContainer(dc);
        this.doTest((DataContainer)dc);
    }

    private void initializeDefaultDataContainer(DefaultDataContainer dc) {
        InternalEntryFactoryImpl entryFactory = new InternalEntryFactoryImpl();
        EmbeddedTimeService timeService = new EmbeddedTimeService();
        TestingUtil.inject(entryFactory, timeService);
        TestingUtil.inject(dc, (evicted, cmd) -> CompletableFutures.completedNull(), new PassivationManagerStub(), entryFactory, new ActivationManagerStub(), null, timeService, null, new InternalExpirationManager(){

            public void processExpiration() {
            }

            public boolean isEnabled() {
                return false;
            }

            public CompletableFuture<Boolean> entryExpiredInMemory(InternalCacheEntry entry, long currentTime, boolean writeOperation) {
                return null;
            }

            public CompletionStage<Void> handleInStoreExpirationInternal(Object key) {
                return null;
            }

            public CompletionStage<Void> handleInStoreExpirationInternal(MarshallableEntry marshalledEntry) {
                return null;
            }

            public CompletionStage<Boolean> handlePossibleExpiration(InternalCacheEntry entry, int segment, boolean isWrite) {
                return null;
            }

            public void addInternalListener(InternalExpirationManager.ExpirationConsumer consumer) {
            }

            public void removeInternalListener(Object listener) {
            }
        });
    }

    private long threeQuarterMemorySize(int numKeys, int keyLength, int valueLength) {
        long total = numKeys * (32 + keyLength + valueLength);
        return total - total / 4L;
    }

    private void doTest(DataContainer dc) throws InterruptedException {
        this.doTest(dc, true);
        this.doTest(dc, false);
    }

    private void doTest(final DataContainer dc, boolean warmup) throws InterruptedException {
        Thread[] threads;
        this.latch = new CountDownLatch(1);
        final byte[] keyFirstBytes = new byte[4];
        final ConcurrentSkipListMap perf = new ConcurrentSkipListMap();
        final AtomicBoolean run = new AtomicBoolean(true);
        final int actual_num_loops = warmup ? 10000 : 10000;
        Thread getter = new Thread(this){
            final /* synthetic */ DataContainerStressTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                int runs;
                ThreadLocalRandom R = ThreadLocalRandom.current();
                this.this$0.waitForStart();
                long start = System.nanoTime();
                byte[] captureByte = new byte[1];
                byte[] key = Arrays.copyOf(keyFirstBytes, 5);
                for (runs = 0; this.this$0.use_time && run.get() || runs < actual_num_loops; ++runs) {
                    R.nextBytes(captureByte);
                    key[4] = captureByte[0];
                    dc.get((Object)key);
                }
                perf.put("GET", this.this$0.opsPerMS(System.nanoTime() - start, runs));
            }
        };
        Thread putter = new Thread(this){
            final /* synthetic */ DataContainerStressTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                int runs;
                ThreadLocalRandom R = ThreadLocalRandom.current();
                this.this$0.waitForStart();
                long start = System.nanoTime();
                byte[] captureByte = new byte[1];
                byte[] key = Arrays.copyOf(keyFirstBytes, 5);
                byte[] value = new byte[20];
                Metadata metadata = new EmbeddedMetadata.Builder().build();
                for (runs = 0; this.this$0.use_time && run.get() || runs < actual_num_loops; ++runs) {
                    R.nextBytes(captureByte);
                    key[4] = captureByte[0];
                    R.nextBytes(value);
                    dc.put((Object)key, (Object)value, metadata);
                }
                perf.put("PUT", this.this$0.opsPerMS(System.nanoTime() - start, runs));
            }
        };
        Thread remover = new Thread(this){
            final /* synthetic */ DataContainerStressTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                int runs;
                ThreadLocalRandom R = ThreadLocalRandom.current();
                this.this$0.waitForStart();
                long start = System.nanoTime();
                byte[] captureByte = new byte[1];
                byte[] key = Arrays.copyOf(keyFirstBytes, 5);
                for (runs = 0; this.this$0.use_time && run.get() || runs < actual_num_loops; ++runs) {
                    R.nextBytes(captureByte);
                    key[4] = captureByte[0];
                    dc.remove((Object)key);
                }
                perf.put("REM", this.this$0.opsPerMS(System.nanoTime() - start, runs));
            }
        };
        for (Thread t : threads = new Thread[]{getter, putter, remover}) {
            t.start();
        }
        this.latch.countDown();
        Thread.sleep(warmup ? 10000L : 45000L);
        run.set(false);
        for (Thread t : threads) {
            t.join();
        }
        if (!warmup) {
            log.warnf("%s: Performance: %s", (Object)dc.getClass().getSimpleName(), perf);
        }
    }

    private void waitForStart() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String opsPerMS(long nanos, int ops) {
        long totalMillis = TimeUnit.NANOSECONDS.toMillis(nanos);
        if (totalMillis > 0L) {
            return (long)ops / totalMillis + " ops/ms";
        }
        return "NAN ops/ms";
    }
}

