/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.notifications.cachelistener.cluster.AbstractClusterListenerUtilTest;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.transaction.TransactionMode;
import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractClusterListenerDistAddListenerTest
extends AbstractClusterListenerUtilTest {
    public static final String PRE_CLUSTER_LISTENERS_RELEASE = "pre_cluster_listeners_release_";
    public static final String POST_CLUSTER_LISTENERS_INVOKED = "post_cluster_listeners_invoked_";
    public static final String POST_CLUSTER_LISTENERS_RELEASE = "post_cluster_listeners_release_";
    public static final String PRE_CLUSTER_LISTENERS_INVOKED = "pre_cluster_listeners_invoked_";

    protected AbstractClusterListenerDistAddListenerTest(boolean tx) {
        super(tx, CacheMode.DIST_SYNC);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(this.cacheMode).partitionHandling().mergePolicy(null);
        if (this.tx) {
            this.builderUsed.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
            this.builderUsed.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        }
        this.builderUsed.expiration().disableReaper();
        this.createClusteredCaches(3, "cluster-listener", TestDataSCI.INSTANCE, this.builderUsed);
        this.injectTimeServices();
    }

    @Test
    public void testMemberJoinsWhileClusterListenerInstalled() throws TimeoutException, InterruptedException, ExecutionException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilListenerInstalled(cache0, checkPoint);
        checkPoint.triggerForever("post_add_listener_release_" + String.valueOf(cache0));
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        Future<Void> future = this.fork(() -> {
            cache1.addListener((Object)clusterListener);
            return null;
        });
        checkPoint.awaitStrict("pre_add_listener_invoked_" + String.valueOf(cache0), 10L, TimeUnit.SECONDS);
        this.addClusteredCacheManager();
        this.waitForClusterToForm("cluster-listener");
        Cache cache3 = this.cache(3, "cluster-listener");
        checkPoint.triggerForever("pre_add_listener_release_" + String.valueOf(cache0));
        future.get(10L, TimeUnit.SECONDS);
        MagicKey key = new MagicKey(cache3);
        this.verifySimpleInsertion(cache3, key, "first-value", null, clusterListener, "first-value");
    }

    @Test
    public void testMemberJoinsWhileClusterListenerInstalledDuplicate() throws TimeoutException, InterruptedException, ExecutionException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilListenerInstalled(cache0, checkPoint);
        checkPoint.triggerForever("pre_add_listener_release_" + String.valueOf(cache0));
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        Future<Void> future = this.fork(() -> {
            cache1.addListener((Object)clusterListener);
            return null;
        });
        checkPoint.awaitStrict("post_add_listener_invoked_" + String.valueOf(cache0), 10L, TimeUnit.SECONDS);
        this.addClusteredCacheManager();
        this.waitForClusterToForm("cluster-listener");
        Cache cache3 = this.cache(3, "cluster-listener");
        checkPoint.triggerForever("post_add_listener_release_" + String.valueOf(cache0));
        future.get(10L, TimeUnit.SECONDS);
        MagicKey key = new MagicKey(cache3);
        this.verifySimpleInsertion(cache3, key, "first-value", null, clusterListener, "first-value");
    }

    @Test
    public void testMemberJoinsAndRetrievesClusterListenersButMainListenerNodeDiesBeforeInstalled() throws TimeoutException, InterruptedException, ExecutionException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache1.addListener((Object)clusterListener);
        Assert.assertEquals((Object)this.manager(0).getAddress(), this.manager(0).getMembers().get(0));
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilRequestingListeners(cache0, checkPoint);
        checkPoint.triggerForever(PRE_CLUSTER_LISTENERS_RELEASE + String.valueOf(cache0));
        this.addClusteredCacheManager();
        Future<Cache> future = this.fork(() -> this.cache(3, "cluster-listener"));
        checkPoint.awaitStrict(POST_CLUSTER_LISTENERS_INVOKED + String.valueOf(cache0), 10L, TimeUnit.SECONDS);
        log.info((Object)"Killing node 1 ..");
        TestingUtil.killCacheManagers(this.manager(1));
        this.cacheManagers.remove(1);
        log.info((Object)"Node 1 killed");
        checkPoint.triggerForever(POST_CLUSTER_LISTENERS_RELEASE + String.valueOf(cache0));
        TestingUtil.blockUntilViewsReceived(10000, false, this.cacheManagers);
        TestingUtil.waitForNoRebalance(this.caches("cluster-listener"));
        Cache cache3 = future.get(10L, TimeUnit.SECONDS);
        for (Object listener : TestingUtil.getListeners(cache3)) {
            Assert.assertFalse((boolean)(listener instanceof RemoteClusterListener));
        }
    }

    @Test
    public void testNodeJoiningAndStateNodeDiesWithExistingClusterListener() throws TimeoutException, InterruptedException, ExecutionException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        int initialCache0ListenerSize = TestingUtil.getListeners(cache0).size();
        int initialCache1ListenerSize = TestingUtil.getListeners(cache1).size();
        int initialCache2ListenerSize = TestingUtil.getListeners(cache2).size();
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache2.addListener((Object)clusterListener);
        Assert.assertEquals((int)TestingUtil.getListeners(cache0).size(), (int)(initialCache0ListenerSize + (this.cacheMode.isDistributed() ? 1 : 0)));
        Assert.assertEquals((int)TestingUtil.getListeners(cache1).size(), (int)(initialCache1ListenerSize + (this.cacheMode.isDistributed() ? 1 : 0)));
        Assert.assertEquals((int)TestingUtil.getListeners(cache2).size(), (int)(initialCache2ListenerSize + 1));
        Assert.assertEquals((Object)this.manager(0).getAddress(), this.manager(0).getMembers().get(0));
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilRequestingListeners(cache0, checkPoint);
        checkPoint.triggerForever(POST_CLUSTER_LISTENERS_RELEASE + String.valueOf(cache0));
        this.addClusteredCacheManager();
        Future<Cache> future = this.fork(() -> this.cache(3, "cluster-listener"));
        checkPoint.awaitStrict(PRE_CLUSTER_LISTENERS_INVOKED + String.valueOf(cache0), 10L, TimeUnit.SECONDS);
        log.info((Object)"Killing node 0 ..");
        TestingUtil.killCacheManagers(this.manager(0));
        this.cacheManagers.remove(0);
        log.info((Object)"Node 0 killed");
        TestingUtil.blockUntilViewsReceived(10000, false, this.cacheManagers);
        TestingUtil.waitForNoRebalance(this.caches("cluster-listener"));
        checkPoint.triggerForever(PRE_CLUSTER_LISTENERS_INVOKED + String.valueOf(cache0));
        Cache cache3 = future.get(10L, TimeUnit.SECONDS);
        MagicKey key = new MagicKey(cache3);
        this.verifySimpleInsertion((Cache<Object, String>)cache3, key, "first-value", null, clusterListener, "first-value");
    }

    @Test(enabled=false, description="Test may not be doable, check TODO in test")
    public void testNodeJoiningAndStateNodeDiesWhichHasClusterListener() throws TimeoutException, InterruptedException, ExecutionException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        int initialCache0ListenerSize = TestingUtil.getListeners(cache0).size();
        int initialCache1ListenerSize = TestingUtil.getListeners(cache1).size();
        int initialCache2ListenerSize = TestingUtil.getListeners(cache2).size();
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        Assert.assertEquals((int)TestingUtil.getListeners(cache0).size(), (int)(initialCache0ListenerSize + 1));
        Assert.assertEquals((int)TestingUtil.getListeners(cache1).size(), (int)(initialCache1ListenerSize + 1));
        Assert.assertEquals((int)TestingUtil.getListeners(cache2).size(), (int)(initialCache2ListenerSize + 1));
        Assert.assertEquals((Object)this.manager(0).getAddress(), this.manager(0).getMembers().get(0));
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilRequestingListeners(cache0, checkPoint);
        checkPoint.triggerForever(POST_CLUSTER_LISTENERS_RELEASE + String.valueOf(cache0));
        this.waitUntilViewChangeOccurs((CacheContainer)this.manager(1), "manager1", checkPoint);
        checkPoint.trigger("pre_view_listener_release_manager1");
        this.addClusteredCacheManager();
        this.waitUntilViewChangeOccurs((CacheContainer)this.manager(3), "manager3", checkPoint);
        checkPoint.trigger("pre_view_listener_release_manager3");
        Future<Cache> future = this.fork(() -> this.cache(3, "cluster-listener"));
        checkPoint.awaitStrict("post_view_listener_invoked_manager1", 10L, TimeUnit.SECONDS);
        checkPoint.awaitStrict(PRE_CLUSTER_LISTENERS_INVOKED + String.valueOf(cache0), 10L, TimeUnit.SECONDS);
        log.info((Object)"Killing node 0 ..");
        TestingUtil.killCacheManagers(this.manager(0));
        this.cacheManagers.remove(0);
        log.info((Object)"Node 0 killed");
        Cache cache3 = future.get(10L, TimeUnit.SECONDS);
        checkPoint.triggerForever("pre_view_listener_release_manager1");
        TestingUtil.blockUntilViewsReceived(60000L, false, cache1, cache2);
        TestingUtil.waitForNoRebalance(cache1, cache2);
        MagicKey key = new MagicKey(cache3);
        cache3.put((Object)key, (Object)"first-value");
        Assert.assertEquals((int)TestingUtil.getListeners(cache1).size(), (int)initialCache1ListenerSize);
        Assert.assertEquals((int)TestingUtil.getListeners(cache2).size(), (int)initialCache2ListenerSize);
        for (Object listener : TestingUtil.getListeners(cache3)) {
            Assert.assertFalse((boolean)(listener instanceof RemoteClusterListener));
        }
    }

    protected void waitUntilRequestingListeners(Cache<?, ?> cache, CheckPoint checkPoint) {
        StateProvider sp = TestingUtil.extractComponent(cache, StateProvider.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)sp);
        StateProvider mockProvider = (StateProvider)Mockito.mock(StateProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((StateProvider)Mockito.doAnswer(invocation -> {
            checkPoint.trigger(PRE_CLUSTER_LISTENERS_INVOKED + String.valueOf(cache));
            checkPoint.awaitStrict(PRE_CLUSTER_LISTENERS_RELEASE + String.valueOf(cache), 10L, TimeUnit.SECONDS);
            try {
                Object object = forwardedAnswer.answer(invocation);
                return object;
            }
            finally {
                checkPoint.trigger(POST_CLUSTER_LISTENERS_INVOKED + String.valueOf(cache));
                checkPoint.awaitStrict(POST_CLUSTER_LISTENERS_RELEASE + String.valueOf(cache), 10L, TimeUnit.SECONDS);
            }
        }).when((Object)mockProvider)).getClusterListenersToInstall();
        TestingUtil.replaceComponent(cache, StateProvider.class, mockProvider, true);
    }
}

