/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.List;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.SinglePhaseCommitForPessimisticCachesTest")
public class SinglePhaseCommitForPessimisticCachesTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = SinglePhaseCommitForPessimisticCachesTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        c.clustering().hash().numOwners(3).transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(TestDataSCI.INSTANCE, c, 3);
        this.waitForClusterToForm();
    }

    public void testSinglePhaseCommit() throws Exception {
        Object k0_1 = this.getKeyForCache(0);
        Object k0_2 = this.getKeyForCache(0);
        List members = this.advancedCache(0).getRpcManager().getTransport().getMembers();
        assert (this.cacheTopology(0).getDistribution(k0_1).writeOwners().containsAll(members));
        assert (this.cacheTopology(0).getDistribution(k0_2).writeOwners().containsAll(members));
        TxCountInterceptor interceptor0 = new TxCountInterceptor();
        TxCountInterceptor interceptor1 = new TxCountInterceptor();
        TestingUtil.extractInterceptorChain(this.advancedCache(0)).addInterceptor((AsyncInterceptor)interceptor0, 1);
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)interceptor1, 2);
        this.tm(2).begin();
        this.cache(2).put(k0_1, (Object)"v");
        this.cache(2).put(k0_2, (Object)"v");
        this.tm(2).commit();
        Assert.assertEquals((int)interceptor0.lockCount, (int)2);
        Assert.assertEquals((int)interceptor1.lockCount, (int)2);
        Assert.assertEquals((int)interceptor0.prepareCount, (int)1);
        Assert.assertEquals((int)interceptor1.prepareCount, (int)1);
        Assert.assertEquals((int)interceptor0.commitCount, (int)0);
        Assert.assertEquals((int)interceptor1.commitCount, (int)0);
    }

    public static class TxCountInterceptor
    extends DDAsyncInterceptor {
        public volatile int prepareCount;
        public volatile int commitCount;
        public volatile int lockCount;
        public volatile int putCount;
        public volatile int getCount;

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            ++this.prepareCount;
            return super.visitPrepareCommand(ctx, command);
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            ++this.commitCount;
            return super.visitCommitCommand(ctx, command);
        }

        public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
            ++this.lockCount;
            return super.visitLockControlCommand(ctx, command);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            ++this.putCount;
            return super.visitPutKeyValueCommand(ctx, command);
        }

        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            ++this.getCount;
            return super.visitGetKeyValueCommand(ctx, command);
        }
    }
}

