/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

abstract class AbstractFunctionalTest
extends MultipleCacheManagersTest {
    static final String DIST = "dist";
    static final String REPL = "repl";
    static final String SIMPLE = "simple";
    int numNodes = 2;
    int numDistOwners = 1;
    boolean isSync = true;
    boolean persistence = true;
    boolean passivation = false;
    FunctionalMapImpl<Integer, String> fmapS1;
    FunctionalMapImpl<Integer, String> fmapS2;
    FunctionalMapImpl<Integer, String> fmapL1;
    FunctionalMapImpl<Integer, String> fmapL2;
    FunctionalMapImpl<Object, String> fmapD1;
    FunctionalMapImpl<Object, String> fmapD2;
    FunctionalMapImpl<Object, String> fmapR1;
    FunctionalMapImpl<Object, String> fmapR2;
    private boolean skipSimpleCache = false;

    AbstractFunctionalTest() {
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder localBuilder = new ConfigurationBuilder();
        this.configureCache(localBuilder);
        this.createClusteredCaches(this.numNodes, TestDataSCI.INSTANCE, localBuilder);
        this.defineSimpleCache();
        ConfigurationBuilder distBuilder = new ConfigurationBuilder();
        distBuilder.clustering().cacheMode(this.isSync ? CacheMode.DIST_SYNC : CacheMode.DIST_ASYNC).hash().numOwners(this.numDistOwners);
        this.configureCache(distBuilder);
        this.cacheManagers.forEach(cm -> cm.defineConfiguration(DIST, distBuilder.build()));
        ConfigurationBuilder replBuilder = new ConfigurationBuilder();
        replBuilder.clustering().cacheMode(this.isSync ? CacheMode.REPL_SYNC : CacheMode.REPL_ASYNC);
        this.configureCache(replBuilder);
        this.cacheManagers.forEach(cm -> cm.defineConfiguration(REPL, replBuilder.build()));
        this.waitForClusterToForm(DIST, REPL);
    }

    private void defineSimpleCache() {
        ConfigurationBuilder simpleBuilder = new ConfigurationBuilder();
        this.configureCache(simpleBuilder);
        simpleBuilder.persistence().stores().clear();
        simpleBuilder.simpleCache(true);
        try {
            this.cacheManagers.forEach(cm -> cm.defineConfiguration(SIMPLE, simpleBuilder.build()));
        }
        catch (CacheConfigurationException e) {
            this.skipSimpleCache = e.getMessage().startsWith("ISPN000381");
        }
    }

    protected void configureCache(ConfigurationBuilder builder) {
        builder.statistics().disable();
        if (this.transactional != null) {
            builder.transaction().transactionMode(this.transactionMode());
            if (this.lockingMode != null) {
                builder.transaction().lockingMode(this.lockingMode);
            }
        }
        if (this.isolationLevel != null) {
            builder.locking().isolationLevel(this.isolationLevel);
        }
        if (this.persistence) {
            builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
            builder.persistence().passivation(this.passivation);
        }
    }

    protected AbstractFunctionalTest persistence(boolean enabled) {
        this.persistence = enabled;
        return this;
    }

    protected AbstractFunctionalTest passivation(boolean enabled) {
        this.passivation = enabled;
        return this;
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        if (this.cleanupAfterTest()) {
            this.initMaps();
        }
    }

    @Override
    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        super.createBeforeMethod();
        if (this.cleanupAfterMethod()) {
            this.initMaps();
        }
    }

    protected void initMaps() {
        if (!this.isSkipSimpleCache()) {
            this.fmapS1 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(0), SIMPLE));
            this.fmapS2 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(0), SIMPLE));
        }
        this.fmapL1 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(0), null));
        this.fmapL2 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(0), null));
        this.fmapD1 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(0), DIST));
        this.fmapD2 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(1), DIST));
        this.fmapR1 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(0), REPL));
        this.fmapR2 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(1), REPL));
    }

    protected <K, V> AdvancedCache<K, V> getAdvancedCache(EmbeddedCacheManager cm, String cacheName) {
        return (AdvancedCache)(cacheName == null ? cm.getCache() : cm.getCache(cacheName));
    }

    protected boolean isSkipSimpleCache() {
        return this.skipSimpleCache;
    }

    protected void checkSimpleCacheAvailable() {
        if (this.isSkipSimpleCache()) {
            throw new SkipException("Skip test because simple cache not available");
        }
    }
}

