/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.PessimisticDistSyncTxStoreSharedTest")
public class PessimisticDistSyncTxStoreSharedTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder getCB() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).remoteTimeout(60000L).stateTransfer().timeout(180000L).fetchInMemoryState(true).hash().numOwners(1);
        cb.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC);
        cb.persistence().passivation(false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cb.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).shared(true)).storeName(this.getClass().getSimpleName()).async().disable();
        return cb;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(this.getCB(), 1);
        this.defineConfigurationOnAllManagers("P006", this.getCB());
        this.waitForClusterToForm();
    }

    @Test
    public void testInvalidPut() {
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("P006");
        IntSet allSegments = IntSets.immutableRangeSet((int)cache.getCacheConfiguration().clustering().hash().numSegments());
        for (int i = 0; i < 4; ++i) {
            cache.put((Object)(((EmbeddedCacheManager)this.cacheManagers.get(0)).getAddress().toString() + "-" + i), (Object)"42");
        }
        DummyInMemoryStore cs1 = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        Set keys = PersistenceUtil.toKeySet((NonBlockingStore)cs1, (IntSet)allSegments, null);
        Assert.assertEquals((int)keys.size(), (int)4);
        this.addClusterEnabledCacheManager(this.getCB()).defineConfiguration("P006", this.getCB().build());
        this.waitForClusterToForm("P006");
        cache = ((EmbeddedCacheManager)this.cacheManagers.get(1)).getCache("P006");
        for (int i = 0; i < 4; ++i) {
            cache.put((Object)(((EmbeddedCacheManager)this.cacheManagers.get(1)).getAddress().toString() + "-" + i), (Object)"42");
        }
        DummyInMemoryStore cs2 = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        log.debugf("Load from cache store via cache 1", new Object[0]);
        HashSet mergedKeys = new HashSet(PersistenceUtil.toKeySet((NonBlockingStore)cs1, (IntSet)allSegments, null));
        log.debugf("Load from cache store via cache 2", new Object[0]);
        mergedKeys.addAll(PersistenceUtil.toKeySet((NonBlockingStore)cs2, (IntSet)allSegments, null));
        Assert.assertEquals((int)mergedKeys.size(), (int)8);
    }
}

