/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.L1Manager;
import org.infinispan.distribution.RemoteValueRetrievedListener;
import org.infinispan.globalstate.NoOpGlobalConfigurationManager;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.distribution.L1WriteSynchronizer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.transaction.TransactionMode;
import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.BaseDistSyncL1Test")
public abstract class BaseDistSyncL1Test
extends BaseDistFunctionalTest<Object, String> {
    protected static final String key = "key-to-the-cache";
    protected static final String firstValue = "first-put";
    protected static final String secondValue = "second-put";

    @Override
    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder builder = super.buildConfiguration();
        builder.locking().isolationLevel(this.isolationLevel);
        return builder;
    }

    @Override
    protected void amendCacheManagerBeforeStart(EmbeddedCacheManager cm) {
        NoOpGlobalConfigurationManager.amendCacheManager(cm);
    }

    protected BlockingInterceptor addBlockingInterceptorBeforeTx(Cache<?, ?> cache, CyclicBarrier barrier, Class<? extends VisitableCommand> commandClass) {
        return this.addBlockingInterceptorBeforeTx(cache, barrier, commandClass, true);
    }

    protected BlockingInterceptor addBlockingInterceptorBeforeTx(Cache<?, ?> cache, CyclicBarrier barrier, Class<? extends VisitableCommand> commandClass, boolean blockAfterCommand) {
        return this.addBlockingInterceptor(cache, barrier, commandClass, this.getDistributionInterceptorClass(), blockAfterCommand);
    }

    protected BlockingInterceptor addBlockingInterceptor(Cache<?, ?> cache, CyclicBarrier barrier, Class<? extends VisitableCommand> commandClass, Class<? extends AsyncInterceptor> interceptorPosition, boolean blockAfterCommand) {
        BlockingInterceptor<? extends VisitableCommand> bi = new BlockingInterceptor<VisitableCommand>(barrier, commandClass, blockAfterCommand, false);
        AsyncInterceptorChain interceptorChain = TestingUtil.extractInterceptorChain(cache);
        AssertJUnit.assertTrue((boolean)interceptorChain.addInterceptorBefore(bi, interceptorPosition));
        return bi;
    }

    protected abstract Class<? extends AsyncInterceptor> getDistributionInterceptorClass();

    protected abstract Class<? extends AsyncInterceptor> getL1InterceptorClass();

    protected <K> void assertL1StateOnLocalWrite(Cache<? super K, ?> cache, Cache<?, ?> updatingCache, K key, Object valueWrite) {
        this.assertIsNotInL1(cache, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertL1GetWithConcurrentUpdate(Cache<Object, String> nonOwnerCache, Cache<Object, String> ownerCache, Object key, String originalValue, String updateValue) throws InterruptedException, ExecutionException, TimeoutException, BrokenBarrierException {
        CyclicBarrier barrier = new CyclicBarrier(2);
        this.addBlockingInterceptorBeforeTx(nonOwnerCache, barrier, GetKeyValueCommand.class);
        try {
            Future<String> future = this.fork(() -> (String)nonOwnerCache.get(key));
            barrier.await(5L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)originalValue, (String)((String)ownerCache.put(key, (Object)updateValue)));
            barrier.await(5L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)originalValue, (String)future.get(5L, TimeUnit.SECONDS));
            BaseDistSyncL1Test.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
            this.assertL1StateOnLocalWrite(nonOwnerCache, ownerCache, key, updateValue);
            AssertJUnit.assertEquals((String)updateValue, (String)((String)nonOwnerCache.get(key)));
            this.assertIsInL1(nonOwnerCache, key);
        }
        finally {
            BaseDistSyncL1Test.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
        }
    }

    @Test
    public void testNoEntryInL1GetWithConcurrentInvalidation() throws InterruptedException, ExecutionException, TimeoutException, BrokenBarrierException {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        this.assertL1GetWithConcurrentUpdate(nonOwnerCache, ownerCache, key, firstValue, secondValue);
    }

    @Test
    public void testEntryInL1GetWithConcurrentInvalidation() throws InterruptedException, ExecutionException, TimeoutException, BrokenBarrierException {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        nonOwnerCache.get((Object)key);
        this.assertIsInL1(nonOwnerCache, key);
        this.assertL1GetWithConcurrentUpdate(nonOwnerCache, ownerCache, key, firstValue, secondValue);
    }

    @Test
    public void testEntryInL1GetWithConcurrentPut() throws InterruptedException, ExecutionException, TimeoutException, BrokenBarrierException {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        nonOwnerCache.get((Object)key);
        this.assertIsInL1(nonOwnerCache, key);
        this.assertL1GetWithConcurrentUpdate(nonOwnerCache, nonOwnerCache, key, firstValue, secondValue);
    }

    @Test
    public void testNoEntryInL1GetWithConcurrentPut() throws InterruptedException, ExecutionException, TimeoutException, BrokenBarrierException {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        this.assertL1GetWithConcurrentUpdate(nonOwnerCache, nonOwnerCache, key, firstValue, secondValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoEntryInL1MultipleConcurrentGetsWithInvalidation() throws TimeoutException, InterruptedException, ExecutionException, BrokenBarrierException {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        CyclicBarrier invalidationBarrier = new CyclicBarrier(2);
        this.addBlockingInterceptor(nonOwnerCache, invalidationBarrier, InvalidateL1Command.class, this.getL1InterceptorClass(), false);
        try {
            AssertJUnit.assertEquals((String)firstValue, (String)((String)nonOwnerCache.get((Object)key)));
            Future<String> futurePut = this.fork(() -> (String)ownerCache.put((Object)key, (Object)secondValue));
            invalidationBarrier.await(5L, TimeUnit.SECONDS);
            nonOwnerCache.getAdvancedCache().getDataContainer().remove((Object)key);
            BaseDistSyncL1Test.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
            CyclicBarrier getBarrier = new CyclicBarrier(2);
            this.addBlockingInterceptorBeforeTx(nonOwnerCache, getBarrier, GetKeyValueCommand.class);
            Future<String> futureGet = this.fork(() -> (String)nonOwnerCache.get((Object)key));
            getBarrier.await(5L, TimeUnit.SECONDS);
            invalidationBarrier.await(5L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)firstValue, (String)futurePut.get(5L, TimeUnit.SECONDS));
            getBarrier.await(5L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)futureGet.get(5L, TimeUnit.SECONDS));
            BaseDistSyncL1Test.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
            this.assertIsNotInL1(nonOwnerCache, key);
            BaseDistSyncL1Test.eventually(() -> {
                AssertJUnit.assertEquals((String)secondValue, (String)((String)nonOwnerCache.get((Object)key)));
                return this.isInL1(nonOwnerCache, key);
            });
        }
        finally {
            BaseDistSyncL1Test.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAfterWriteAlreadyInvalidatedCurrentGet() throws InterruptedException, TimeoutException, BrokenBarrierException, ExecutionException {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        CyclicBarrier nonOwnerGetBarrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor = this.addBlockingInterceptor(nonOwnerCache, nonOwnerGetBarrier, GetKeyValueCommand.class, this.getDistributionInterceptorClass(), true);
        try {
            Future<String> future = this.fork(() -> (String)nonOwnerCache.get((Object)key));
            nonOwnerGetBarrier.await(10L, TimeUnit.SECONDS);
            blockingInterceptor.suspend(true);
            ownerCache.put((Object)key, (Object)secondValue);
            AssertJUnit.assertEquals((String)secondValue, (String)((String)nonOwnerCache.get((Object)key)));
            this.assertIsInL1(nonOwnerCache, key);
            AssertJUnit.assertEquals((String)secondValue, (String)((String)nonOwnerCache.getAdvancedCache().getDataContainer().get((Object)key).getValue()));
            nonOwnerGetBarrier.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)firstValue, (String)future.get(10L, TimeUnit.SECONDS));
            this.assertIsInL1(nonOwnerCache, key);
            AssertJUnit.assertEquals((String)secondValue, (String)((String)nonOwnerCache.getAdvancedCache().getDataContainer().get((Object)key).getValue()));
        }
        finally {
            BaseDistSyncL1Test.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteGetArrivesButWriteOccursBeforeRegistration() throws Throwable {
        Cache<K, V>[] owners = this.getOwners(key, 2);
        Cache ownerCache = owners[0];
        Cache backupOwnerCache = owners[1];
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        this.assertIsNotInL1(nonOwnerCache, key);
        CyclicBarrier getBarrier = new CyclicBarrier(3);
        this.addBlockingInterceptor(ownerCache, getBarrier, GetCacheEntryCommand.class, this.getL1InterceptorClass(), true);
        this.addBlockingInterceptor(backupOwnerCache, getBarrier, GetCacheEntryCommand.class, this.getL1InterceptorClass(), true);
        try {
            Future<String> future = this.fork(() -> (String)nonOwnerCache.get((Object)key));
            getBarrier.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)firstValue, (String)((String)ownerCache.put((Object)key, (Object)secondValue)));
            getBarrier.await(10L, TimeUnit.SECONDS);
            String expectedValue = firstValue;
            AssertJUnit.assertEquals((String)expectedValue, (String)future.get(10L, TimeUnit.SECONDS));
            this.assertIsNotInL1(nonOwnerCache, key);
        }
        finally {
            BaseDistSyncL1Test.removeAllBlockingInterceptorsFromCache(ownerCache);
            BaseDistSyncL1Test.removeAllBlockingInterceptorsFromCache(backupOwnerCache);
        }
    }

    @Test
    public void testGetBlockedInvalidation() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        this.assertIsNotInL1(nonOwnerCache, key);
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilAboutToAcquireLock(nonOwnerCache, checkPoint);
        log.warn((Object)"Doing get here - ignore all previous");
        Future<String> getFuture = this.fork(() -> (String)nonOwnerCache.get((Object)key));
        checkPoint.awaitStrict("pre_acquire_shared_topology_lock_invoked", 10L, TimeUnit.SECONDS);
        Future<String> putFuture = this.fork(() -> (String)ownerCache.put((Object)key, (Object)secondValue));
        Exceptions.expectException(TimeoutException.class, () -> putFuture.get(1L, TimeUnit.SECONDS));
        checkPoint.triggerForever("pre_acquire_shared_topology_lock_released");
        AssertJUnit.assertEquals((String)firstValue, (String)getFuture.get(10L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((String)firstValue, (String)putFuture.get(10L, TimeUnit.SECONDS));
        this.assertIsNotInL1(nonOwnerCache, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBlockingAnotherGet() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        this.assertIsNotInL1(nonOwnerCache, key);
        CheckPoint checkPoint = new CheckPoint();
        StateTransferLock lock = this.waitUntilAboutToAcquireLock(nonOwnerCache, checkPoint);
        try {
            log.warn((Object)"Doing get here - ignore all previous");
            Future<String> getFuture = this.fork(() -> (String)nonOwnerCache.get((Object)key));
            checkPoint.awaitStrict("pre_acquire_shared_topology_lock_invoked", 10L, TimeUnit.SECONDS);
            Future<String> getFuture2 = this.fork(() -> (String)nonOwnerCache.get((Object)key));
            Exceptions.expectException(TimeoutException.class, () -> getFuture2.get(1L, TimeUnit.SECONDS));
            checkPoint.triggerForever("pre_acquire_shared_topology_lock_released");
            AssertJUnit.assertEquals((String)firstValue, (String)getFuture.get(10L, TimeUnit.SECONDS));
            AssertJUnit.assertEquals((String)firstValue, (String)getFuture2.get(10L, TimeUnit.SECONDS));
            this.assertIsInL1(nonOwnerCache, key);
        }
        finally {
            TestingUtil.replaceComponent(nonOwnerCache, StateTransferLock.class, lock, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBlockingAnotherGetWithMiss() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        this.assertIsNotInL1(nonOwnerCache, key);
        CheckPoint checkPoint = new CheckPoint();
        L1Manager l1Manager = this.waitUntilL1Registration(nonOwnerCache, checkPoint);
        try {
            log.warn((Object)"Doing get here - ignore all previous");
            Future<String> getFuture = this.fork(() -> (String)nonOwnerCache.get((Object)key));
            checkPoint.awaitStrict("pre_acquire_shared_topology_lock_invoked", 10L, TimeUnit.SECONDS);
            Future<String> getFuture2 = this.fork(() -> (String)nonOwnerCache.get((Object)key));
            Exceptions.expectException(TimeoutException.class, () -> getFuture2.get(1L, TimeUnit.SECONDS));
            checkPoint.triggerForever("pre_acquire_shared_topology_lock_released");
            AssertJUnit.assertNull((Object)getFuture.get(10L, TimeUnit.SECONDS));
            AssertJUnit.assertNull((Object)getFuture2.get(10L, TimeUnit.SECONDS));
        }
        finally {
            TestingUtil.replaceComponent(nonOwnerCache, L1Manager.class, l1Manager, true);
        }
    }

    @Test
    public void testGetBlockingLocalPut() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        this.assertIsNotInL1(nonOwnerCache, key);
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilAboutToAcquireLock(nonOwnerCache, checkPoint);
        log.warn((Object)"Doing get here - ignore all previous");
        Future<String> getFuture = this.fork(() -> (String)nonOwnerCache.get((Object)key));
        checkPoint.awaitStrict("pre_acquire_shared_topology_lock_invoked", 10L, TimeUnit.SECONDS);
        Future<String> putFuture = this.fork(() -> (String)nonOwnerCache.put((Object)key, (Object)secondValue));
        Exceptions.expectException(TimeoutException.class, () -> putFuture.get(1L, TimeUnit.SECONDS));
        checkPoint.triggerForever("pre_acquire_shared_topology_lock_released");
        AssertJUnit.assertEquals((String)firstValue, (String)getFuture.get(10L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((String)firstValue, (String)putFuture.get(10L, TimeUnit.SECONDS));
        if (nonOwnerCache.getCacheConfiguration().transaction().transactionMode() == TransactionMode.TRANSACTIONAL) {
            this.assertIsInL1(nonOwnerCache, key);
        } else {
            this.assertIsNotInL1(nonOwnerCache, key);
        }
    }

    public void testL1GetAndCacheEntryGet() {
        Cache<K, V>[] owners = this.getOwners(key, 2);
        Cache ownerCache = owners[0];
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        AssertJUnit.assertEquals((String)firstValue, (String)((String)nonOwnerCache.get((Object)key)));
        this.assertIsInL1(nonOwnerCache, key);
        CacheEntry entry = nonOwnerCache.getAdvancedCache().getCacheEntry((Object)key);
        AssertJUnit.assertEquals((Object)key, (Object)entry.getKey());
        AssertJUnit.assertEquals((String)firstValue, (String)((String)entry.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBlockingAnotherGetCacheEntry() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner(key);
        Cache ownerCache = this.getFirstOwner(key);
        ownerCache.put((Object)key, (Object)firstValue);
        this.assertIsNotInL1(nonOwnerCache, key);
        CheckPoint checkPoint = new CheckPoint();
        StateTransferLock lock = this.waitUntilAboutToAcquireLock(nonOwnerCache, checkPoint);
        try {
            log.warn((Object)"Doing get here - ignore all previous");
            Future<String> getFuture = this.fork(() -> (String)nonOwnerCache.get((Object)key));
            checkPoint.awaitStrict("pre_acquire_shared_topology_lock_invoked", 10L, TimeUnit.SECONDS);
            Future<CacheEntry> getFuture2 = this.fork(() -> nonOwnerCache.getAdvancedCache().getCacheEntry((Object)key));
            Exceptions.expectException(TimeoutException.class, () -> getFuture2.get(1L, TimeUnit.SECONDS));
            checkPoint.triggerForever("pre_acquire_shared_topology_lock_released");
            AssertJUnit.assertEquals((String)firstValue, (String)getFuture.get(10L, TimeUnit.SECONDS));
            CacheEntry entry = getFuture2.get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((Object)key, (Object)entry.getKey());
            AssertJUnit.assertEquals((String)firstValue, (String)((String)entry.getValue()));
            this.assertIsInL1(nonOwnerCache, key);
        }
        finally {
            TestingUtil.replaceComponent(nonOwnerCache, StateTransferLock.class, lock, true);
        }
    }

    protected StateTransferLock waitUntilAboutToAcquireLock(Cache<?, ?> cache, CheckPoint checkPoint) {
        StateTransferLock stl = TestingUtil.extractComponent(cache, StateTransferLock.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)stl);
        StateTransferLock mockLock = (StateTransferLock)Mockito.mock(StateTransferLock.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((StateTransferLock)Mockito.doAnswer(invocation -> {
            checkPoint.trigger("pre_acquire_shared_topology_lock_invoked");
            checkPoint.awaitStrict("pre_acquire_shared_topology_lock_released", 10L, TimeUnit.SECONDS);
            return forwardedAnswer.answer(invocation);
        }).when((Object)mockLock)).acquireSharedTopologyLock();
        TestingUtil.replaceComponent(cache, StateTransferLock.class, mockLock, true);
        return stl;
    }

    protected L1Manager waitUntilL1Registration(Cache<?, ?> cache, CheckPoint checkPoint) {
        L1Manager l1Manager = TestingUtil.extractComponent(cache, L1Manager.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)l1Manager);
        L1Manager mockL1 = (L1Manager)Mockito.mock(L1Manager.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer).extraInterfaces(new Class[]{RemoteValueRetrievedListener.class}));
        ((L1Manager)Mockito.doAnswer(invocation -> {
            checkPoint.trigger("pre_acquire_shared_topology_lock_invoked");
            checkPoint.awaitStrict("pre_acquire_shared_topology_lock_released", 10L, TimeUnit.SECONDS);
            return forwardedAnswer.answer(invocation);
        }).when((Object)mockL1)).registerL1WriteSynchronizer(Mockito.notNull(), (L1WriteSynchronizer)Mockito.any(L1WriteSynchronizer.class));
        TestingUtil.replaceComponent(cache, L1Manager.class, mockL1, true);
        return l1Manager;
    }
}

