/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.TimeoutException;

public class ConditionFuture<T> {
    private final Map<Data, Predicate<T>> futures = Collections.synchronizedMap(new IdentityHashMap());
    private final ScheduledExecutorService timeoutExecutor;
    private volatile T lastValue;
    private volatile boolean running = true;

    public ConditionFuture(ScheduledExecutorService timeoutExecutor) {
        this.timeoutExecutor = timeoutExecutor;
    }

    public CompletionStage<Void> newConditionStage(Predicate<T> test, long timeout, TimeUnit timeUnit) {
        return this.newConditionStage(test, TimeoutException::new, timeout, timeUnit);
    }

    public CompletionStage<Void> newConditionStage(Predicate<T> test, Supplier<Exception> exceptionGenerator, long timeout, TimeUnit timeUnit) {
        T localValue;
        Objects.requireNonNull(test);
        if (!this.running) {
            return CompletableFuture.failedFuture((Throwable)new IllegalLifecycleStateException());
        }
        Data data = new Data();
        data.cancelFuture = this.timeoutExecutor.schedule(() -> {
            data.completeExceptionally((Throwable)exceptionGenerator.get());
            return null;
        }, timeout, timeUnit);
        Predicate<T> previous = this.futures.putIfAbsent(data, test);
        if (previous != null) {
            data.cancelFuture.cancel(false);
            throw new IllegalStateException("Inserting the same Data instance");
        }
        if (!this.running) {
            data.cancelFuture.cancel(false);
            this.futures.remove(test);
            data.completeExceptionally((Throwable)new IllegalLifecycleStateException());
        }
        if ((localValue = this.lastValue) != null && test.test(localValue)) {
            data.cancelFuture.cancel(false);
            this.futures.remove(test);
            data.complete(null);
        }
        return data;
    }

    public void update(T value) {
        if (!this.running) {
            throw new IllegalLifecycleStateException();
        }
        this.lastValue = Objects.requireNonNull(value);
        this.checkConditions(value);
    }

    public void updateAsync(T value, Executor executor) {
        if (!this.running) {
            throw new IllegalLifecycleStateException();
        }
        this.lastValue = Objects.requireNonNull(value);
        try {
            executor.execute(() -> this.checkConditions(value));
        }
        catch (Throwable t) {
            this.completeAllExceptionally(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAllExceptionally(Throwable t) {
        ArrayList<Data> completed;
        Map<Data, Predicate<T>> map = this.futures;
        synchronized (map) {
            completed = new ArrayList<Data>(this.futures.keySet());
            this.futures.clear();
        }
        for (Data data : completed) {
            data.cancelFuture.cancel(false);
            data.completeExceptionally(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConditions(T value) {
        ArrayList<Data> completed;
        Map<Data, Predicate<T>> map = this.futures;
        synchronized (map) {
            completed = new ArrayList<Data>(this.futures.size());
            Iterator<Map.Entry<Data, Predicate<T>>> iterator = this.futures.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Data, Predicate<T>> e = iterator.next();
                if (!e.getValue().test(value)) continue;
                Data data = e.getKey();
                completed.add(data);
                iterator.remove();
            }
        }
        for (Data data : completed) {
            data.cancelFuture.cancel(false);
            data.complete(null);
        }
    }

    public void stop() {
        this.running = false;
        this.lastValue = null;
        IllegalLifecycleStateException exception = new IllegalLifecycleStateException();
        this.completeAllExceptionally((Throwable)exception);
    }

    private static class Data
    extends CompletableFuture<Void> {
        volatile Future<Void> cancelFuture;

        private Data() {
        }
    }
}

