package org.immutables.value.processor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.ValueType;

/**
 * Immutable implementation of {@link Datatype.DatatypeTypes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatatypeTypes.builder()}.
 */
@Generated(from = "Datatype.DatatypeTypes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDatatypeTypes extends Datatype.DatatypeTypes {
  private final Proto.AbstractDeclaring definedBy;
  private final String packageGenerated;
  private final ImmutableList<ValueType> types;

  private ImmutableDatatypeTypes(
      Proto.AbstractDeclaring definedBy,
      String packageGenerated,
      ImmutableList<ValueType> types) {
    this.definedBy = definedBy;
    this.packageGenerated = packageGenerated;
    this.types = types;
  }

  /**
   * @return The value of the {@code definedBy} attribute
   */
  @Override
  Proto.AbstractDeclaring definedBy() {
    return definedBy;
  }

  /**
   * @return The value of the {@code packageGenerated} attribute
   */
  @Override
  String packageGenerated() {
    return packageGenerated;
  }

  /**
   * @return The value of the {@code types} attribute
   */
  @Override
  ImmutableList<ValueType> types() {
    return types;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Datatype.DatatypeTypes#definedBy() definedBy} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for definedBy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatatypeTypes withDefinedBy(Proto.AbstractDeclaring value) {
    if (this.definedBy == value) return this;
    Proto.AbstractDeclaring newValue = Objects.requireNonNull(value, "definedBy");
    return new ImmutableDatatypeTypes(newValue, this.packageGenerated, this.types);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Datatype.DatatypeTypes#packageGenerated() packageGenerated} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for packageGenerated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatatypeTypes withPackageGenerated(String value) {
    String newValue = Objects.requireNonNull(value, "packageGenerated");
    if (this.packageGenerated.equals(newValue)) return this;
    return new ImmutableDatatypeTypes(this.definedBy, newValue, this.types);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Datatype.DatatypeTypes#types() types}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatatypeTypes withTypes(ValueType... elements) {
    ImmutableList<ValueType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDatatypeTypes(this.definedBy, this.packageGenerated, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Datatype.DatatypeTypes#types() types}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of types elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatatypeTypes withTypes(Iterable<? extends ValueType> elements) {
    if (this.types == elements) return this;
    ImmutableList<ValueType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDatatypeTypes(this.definedBy, this.packageGenerated, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatatypeTypes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatatypeTypes
        && equalTo((ImmutableDatatypeTypes) another);
  }

  private boolean equalTo(ImmutableDatatypeTypes another) {
    return definedBy.equals(another.definedBy)
        && packageGenerated.equals(another.packageGenerated)
        && types.equals(another.types);
  }

  /**
   * Computes a hash code from attributes: {@code definedBy}, {@code packageGenerated}, {@code types}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + definedBy.hashCode();
    h += (h << 5) + packageGenerated.hashCode();
    h += (h << 5) + types.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DatatypeTypes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DatatypeTypes")
        .omitNullValues()
        .add("definedBy", definedBy)
        .add("packageGenerated", packageGenerated)
        .add("types", types)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Datatype.DatatypeTypes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatatypeTypes instance
   */
  public static ImmutableDatatypeTypes copyOf(Datatype.DatatypeTypes instance) {
    if (instance instanceof ImmutableDatatypeTypes) {
      return (ImmutableDatatypeTypes) instance;
    }
    return ImmutableDatatypeTypes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatatypeTypes ImmutableDatatypeTypes}.
   * <pre>
   * ImmutableDatatypeTypes.builder()
   *    .definedBy(org.immutables.value.processor.meta.Proto.AbstractDeclaring) // required {@link Datatype.DatatypeTypes#definedBy() definedBy}
   *    .packageGenerated(String) // required {@link Datatype.DatatypeTypes#packageGenerated() packageGenerated}
   *    .addTypes|addAllTypes(org.immutables.value.processor.meta.ValueType) // {@link Datatype.DatatypeTypes#types() types} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDatatypeTypes builder
   */
  public static ImmutableDatatypeTypes.Builder builder() {
    return new ImmutableDatatypeTypes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatatypeTypes ImmutableDatatypeTypes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Datatype.DatatypeTypes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEFINED_BY = 0x1L;
    private static final long INIT_BIT_PACKAGE_GENERATED = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Proto.AbstractDeclaring definedBy;
    private @Nullable String packageGenerated;
    private ImmutableList.Builder<ValueType> types = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatatypeTypes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Datatype.DatatypeTypes instance) {
      Objects.requireNonNull(instance, "instance");
      definedBy(instance.definedBy());
      packageGenerated(instance.packageGenerated());
      addAllTypes(instance.types());
      return this;
    }

    /**
     * Initializes the value for the {@link Datatype.DatatypeTypes#definedBy() definedBy} attribute.
     * @param definedBy The value for definedBy 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder definedBy(Proto.AbstractDeclaring definedBy) {
      this.definedBy = Objects.requireNonNull(definedBy, "definedBy");
      initBits &= ~INIT_BIT_DEFINED_BY;
      return this;
    }

    /**
     * Initializes the value for the {@link Datatype.DatatypeTypes#packageGenerated() packageGenerated} attribute.
     * @param packageGenerated The value for packageGenerated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder packageGenerated(String packageGenerated) {
      this.packageGenerated = Objects.requireNonNull(packageGenerated, "packageGenerated");
      initBits &= ~INIT_BIT_PACKAGE_GENERATED;
      return this;
    }

    /**
     * Adds one element to {@link Datatype.DatatypeTypes#types() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTypes(ValueType element) {
      this.types.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Datatype.DatatypeTypes#types() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTypes(ValueType... elements) {
      this.types.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Datatype.DatatypeTypes#types() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder types(Iterable<? extends ValueType> elements) {
      this.types = ImmutableList.builder();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link Datatype.DatatypeTypes#types() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTypes(Iterable<? extends ValueType> elements) {
      this.types.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatatypeTypes ImmutableDatatypeTypes}.
     * @return An immutable instance of DatatypeTypes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatatypeTypes build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDatatypeTypes(definedBy, packageGenerated, types.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEFINED_BY) != 0) attributes.add("definedBy");
      if ((initBits & INIT_BIT_PACKAGE_GENERATED) != 0) attributes.add("packageGenerated");
      return "Cannot build DatatypeTypes, some of required attributes are not set " + attributes;
    }
  }
}
