/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.url;

import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import org.htmlunit.csp.Constants;
import org.htmlunit.csp.url.URLWithScheme;

public class URI
extends URLWithScheme {
    public URI(String scheme, String host, int port, String path) {
        super(scheme, host, port, path);
    }

    public static Optional<URI> parseURI(String uri) {
        Matcher matcher = Constants.HOST_SOURCE_PATTERN.matcher(uri);
        if (!matcher.find()) {
            return Optional.empty();
        }
        String scheme = matcher.group("scheme");
        if (scheme == null) {
            return Optional.empty();
        }
        scheme = scheme.substring(0, scheme.length() - 3);
        String portString = matcher.group("port");
        int port = portString == null ? URI.defaultPortForProtocol(scheme.toLowerCase(Locale.ROOT)) : (":*".equals(portString) ? -200 : Integer.parseInt(portString.substring(1)));
        String host = matcher.group("host");
        String path = matcher.group("path");
        if (path == null) {
            path = "";
        }
        return Optional.of(new URI(scheme, host, port, path));
    }

    public static int defaultPortForProtocol(String scheme) {
        switch (scheme) {
            case "ftp": {
                return 21;
            }
            case "file": {
                return -1;
            }
            case "gopher": {
                return 70;
            }
            case "http": {
                return 80;
            }
            case "https": {
                return 443;
            }
            case "ws": {
                return 80;
            }
            case "wss": {
                return 443;
            }
        }
        return -1;
    }
}

