/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.data.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.search.util.common.impl.Contracts;

public final class LinkedNode<T>
implements Iterable<T> {
    public final T value;
    private final LinkedNode<T> tail;
    public final LinkedNode<T> last;

    public static <T> LinkedNode<T> of(T value) {
        return new LinkedNode<T>(value, null);
    }

    @SafeVarargs
    public static <T> LinkedNode<T> of(T ... values) {
        Contracts.assertNotNullNorEmpty(values, "values");
        LinkedNode<T> tail = null;
        for (int i = values.length - 1; i >= 0; --i) {
            tail = new LinkedNode<T>(values[i], tail);
        }
        return tail;
    }

    private LinkedNode(T value, LinkedNode<T> tail) {
        this.value = value;
        this.tail = tail;
        this.last = tail == null ? this : tail.last;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(" => ");
            }
            sb.append(it.next());
        }
        return sb.append(']').toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LinkedNode)) {
            return false;
        }
        LinkedNode other = (LinkedNode)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.tail, other.tail);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.tail);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private LinkedNode<T> next;
            {
                this.next = LinkedNode.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object value = this.next.value;
                this.next = this.next.tail;
                return value;
            }
        };
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1040);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public LinkedNode<T> withHead(T headValue) {
        return new LinkedNode<T>(headValue, this);
    }

    public Optional<LinkedNode<T>> findAndReverse(Predicate<T> valuePredicate) {
        return this.findAndReverse(valuePredicate, this);
    }

    public Optional<LinkedNode<T>> findAndReverse(Predicate<T> valuePredicate, LinkedNode<T> head) {
        if (valuePredicate.test(this.value)) {
            return Optional.of(head.reverse(null, this));
        }
        if (this.tail != null) {
            return this.tail.findAndReverse(valuePredicate, head);
        }
        return Optional.empty();
    }

    private LinkedNode<T> reverse(LinkedNode<T> newTail, LinkedNode<T> lastIncludedNode) {
        LinkedNode<T> thisWithNewTail = new LinkedNode<T>(this.value, newTail);
        if (lastIncludedNode == this) {
            return thisWithNewTail;
        }
        return this.tail.reverse(thisWithNewTail, lastIncludedNode);
    }
}

