/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.scope.impl;

import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScope;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.aggregation.dsl.impl.DefaultSearchAggregationFactory;
import org.hibernate.search.engine.search.aggregation.dsl.impl.SearchAggregationDslContextImpl;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.impl.DefaultSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.impl.SearchPredicateDslContextImpl;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.projection.dsl.impl.DefaultSearchProjectionFactory;
import org.hibernate.search.engine.search.projection.dsl.impl.SearchProjectionDslContextImpl;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.engine.search.query.dsl.impl.DefaultSearchQuerySelectStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.impl.DefaultSearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.impl.SearchSortDslContextImpl;

class MappedIndexScopeImpl<C, R, E>
implements MappedIndexScope<R, E> {
    private final IndexScope<C> delegate;

    MappedIndexScopeImpl(IndexScope<C> delegate) {
        this.delegate = delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "delegate=" + this.delegate + "]";
    }

    @Override
    public <LOS> SearchQuerySelectStep<?, R, E, LOS, SearchProjectionFactory<R, E>, ?> search(BackendSessionContext sessionContext, LoadingContextBuilder<R, E, LOS> loadingContextBuilder) {
        return new DefaultSearchQuerySelectStep<R, E, LOS, C>(this.delegate, sessionContext, loadingContextBuilder);
    }

    @Override
    public SearchPredicateFactory predicate() {
        return new DefaultSearchPredicateFactory(SearchPredicateDslContextImpl.root(this.delegate.searchPredicateBuilderFactory()));
    }

    @Override
    public SearchSortFactory sort() {
        return new DefaultSearchSortFactory(SearchSortDslContextImpl.root(this.delegate.searchSortBuilderFactory(), this.predicate()));
    }

    @Override
    public SearchProjectionFactory<R, E> projection() {
        return new DefaultSearchProjectionFactory(SearchProjectionDslContextImpl.root(this.delegate.searchProjectionFactory()));
    }

    @Override
    public SearchAggregationFactory aggregation() {
        return new DefaultSearchAggregationFactory(SearchAggregationDslContextImpl.root(this.delegate.searchAggregationFactory(), this.predicate()));
    }
}

