/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.db2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.db2.DB2GeometryTypeDescriptor;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DB2SpatialDialect
extends DB2Dialect
implements SpatialDialect {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, String> spatialRelationNames = new HashMap<Integer, String>();

    public DB2SpatialDialect() {
        this.registerSpatialType();
        this.registerSpatialFunctions();
        this.initializeRelationNames();
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        DB2GeometryTypeDescriptor typeDescriptor = this.mkDescriptor(serviceRegistry);
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(typeDescriptor));
        typeContributions.contributeType((BasicType)new JTSGeometryType(typeDescriptor));
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    private DB2GeometryTypeDescriptor mkDescriptor(ServiceRegistry serviceRegistry) {
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        Integer srid = this.retrieveSridFromConfiguration(configurationService);
        return new DB2GeometryTypeDescriptor(srid);
    }

    private Integer retrieveSridFromConfiguration(ConfigurationService configurationService) {
        Integer srid = 0;
        try {
            srid = Integer.parseInt((String)configurationService.getSetting("hibernate.spatial.db2.srid", String.class, (Object)"0"));
        }
        catch (NumberFormatException e) {
            throw new HibernateException("Invalid format for configuration parameter (Integer expected): hibernate.spatial.db2.srid", (Throwable)e);
        }
        return srid;
    }

    private void initializeRelationNames() {
        this.spatialRelationNames.put(0, "ST_EQUALS");
        this.spatialRelationNames.put(1, "ST_DISJOINT");
        this.spatialRelationNames.put(2, "ST_TOUCHES");
        this.spatialRelationNames.put(3, "ST_CROSSES");
        this.spatialRelationNames.put(4, "ST_WITHIN");
        this.spatialRelationNames.put(5, "ST_OVERLAPS");
        this.spatialRelationNames.put(6, "ST_CONTAINS");
        this.spatialRelationNames.put(7, "ST_INTERSECTS");
    }

    private void registerSpatialType() {
        this.registerColumnType(2005, " db2gse.ST_Geometry");
    }

    private void registerSpatialFunctions() {
        this.registerFunction("equals", (SQLFunction)new StandardSQLFunction("db2gse.ST_Equals", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("disjoint", (SQLFunction)new StandardSQLFunction("db2gse.ST_Disjoint", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("touches", (SQLFunction)new StandardSQLFunction("db2gse.ST_Touches", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("crosses", (SQLFunction)new StandardSQLFunction("db2gse.ST_Crosses", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("within", (SQLFunction)new StandardSQLFunction("db2gse.ST_Within", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("overlaps", (SQLFunction)new StandardSQLFunction("db2gse.ST_Overlaps", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("contains", (SQLFunction)new StandardSQLFunction("db2gse.ST_Contains", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("intersects", (SQLFunction)new StandardSQLFunction("db2gse.ST_Intersects", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("relate", (SQLFunction)new StandardSQLFunction("db2gse.ST_Relate", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("dimension", (SQLFunction)new StandardSQLFunction("db2gse.ST_Dimension", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("geometrytype", (SQLFunction)new StandardSQLFunction("db2gse.ST_GeometryType", (Type)StandardBasicTypes.STRING));
        this.registerFunction("srid", (SQLFunction)new StandardSQLFunction("db2gse.ST_Srsid", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("db2gse.ST_Envelope"));
        this.registerFunction("astext", (SQLFunction)new StandardSQLFunction("db2gse.ST_AsText", (Type)StandardBasicTypes.STRING));
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("db2gse.ST_AsBinary", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("isempty", (SQLFunction)new StandardSQLFunction("db2gse.ST_IsEmpty", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("issimple", (SQLFunction)new StandardSQLFunction("db2gse.ST_IsSimple", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("boundary", (SQLFunction)new StandardSQLFunction("db2gse.ST_Boundary"));
        this.registerFunction("distance", (SQLFunction)new StandardSQLFunction("db2gse.ST_Distance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("buffer", (SQLFunction)new StandardSQLFunction("db2gse.ST_Buffer"));
        this.registerFunction("convexhull", (SQLFunction)new StandardSQLFunction("db2gse.ST_ConvexHull"));
        this.registerFunction("intersection", (SQLFunction)new StandardSQLFunction("db2gse.ST_Intersection"));
        this.registerFunction("geomunion", (SQLFunction)new StandardSQLFunction("db2gse.ST_Union"));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("db2gse.ST_Difference"));
        this.registerFunction("symdifference", (SQLFunction)new StandardSQLFunction("db2gse.ST_SymDifference"));
        this.registerFunction("dwithin", (SQLFunction)new DWithinFunction());
        this.registerFunction("geomFromText", (SQLFunction)new StandardSQLFunction("DB2GSE.ST_GeomFromText"));
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return "db2gse.ST_Intersects(" + columnName + ", db2gse.ST_Buffer(?, ?, 'METER')) = 1";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return "( db2gse.ST_srsid(" + columnName + ") = ?)";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        if (isEmpty) {
            return "( db2gse.ST_IsEmpty(" + columnName + ") = 1)";
        }
        return "( db2gse.ST_IsEmpty(" + columnName + ") = 0)";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int type) {
        switch (type) {
            case 1: {
                return "db2gse.ST_GetAggrResult(MAX(db2gse.st_BuildMBRAggr(" + columnName + ")))";
            }
            case 2: {
                return "db2gse.ST_GetAggrResult(MAX(db2gse.st_BuildUnionAggr(" + columnName + ")))";
            }
        }
        throw new IllegalArgumentException("Aggregation of type " + type + " are not supported by this dialect");
    }

    @Override
    public String getSpatialFilterExpression(String arg0) {
        throw new UnsupportedOperationException("DB2 Dialect doesn't support spatial filtering");
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        if (code == 3000) {
            return "DB2GSE.ST_GEOMETRY";
        }
        return super.getTypeName(code, length, precision, scale);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        String relationName = this.spatialRelationNames.get(spatialRelation);
        if (relationName != null) {
            if (spatialRelation != 1) {
                return " db2gse." + relationName + "(" + columnName + ", ?) = 1 SELECTIVITY .0001";
            }
            return " db2gse." + relationName + "(" + columnName + ", ?) = 1";
        }
        throw new IllegalArgumentException("Spatial relation " + spatialRelation + " not implemented");
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }

    @Override
    public boolean supportsFiltering() {
        return false;
    }

    private static class DWithinFunction
    extends StandardSQLFunction {
        public DWithinFunction() {
            super("db2gse.ST_Dwithin", (Type)StandardBasicTypes.NUMERIC_BOOLEAN);
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            StringBuilder sb = new StringBuilder("db2gse.ST_Intersects( ");
            sb.append((String)args.get(0)).append(", db2gse.ST_Buffer(").append((String)args.get(1)).append(", ").append((String)args.get(2)).append(", 'METER'))");
            return sb.toString();
        }
    }
}

