/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.db2;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.db2.Db2ClobDecoder;
import org.geolatte.geom.codec.db.db2.Db2ClobEncoder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class DB2GeometryTypeDescriptor
implements SqlTypeDescriptor {
    private final Integer srid;

    public DB2GeometryTypeDescriptor(Integer srid) {
        this.srid = srid;
    }

    public int getSqlType() {
        return 2005;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, this.toText(value, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, (Object)this.toText(value, options));
            }

            private String toText(X value, WrapperOptions options) {
                Geometry geometry = (Geometry)this.getJavaDescriptor().unwrap(value, Geometry.class, options);
                Db2ClobEncoder encoder = new Db2ClobEncoder();
                String encoded = encoder.encode(geometry);
                return encoded;
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(DB2GeometryTypeDescriptor.this.toGeometry(rs.getObject(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(DB2GeometryTypeDescriptor.this.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(DB2GeometryTypeDescriptor.this.toGeometry(statement.getObject(name)), options);
            }
        };
    }

    public Geometry<?> toGeometry(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            Db2ClobDecoder decoder = new Db2ClobDecoder(this.srid);
            return decoder.decode((Clob)object);
        }
        throw new IllegalStateException("Object of type " + object.getClass().getCanonicalName() + " not handled by DB2 as spatial value");
    }
}

