/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jmx;

import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.jmx.IndexingProgressMonitorMBean;
import org.hibernate.search.jmx.JMXRegistrar;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class IndexingProgressMonitor
implements IndexingProgressMonitorMBean,
MassIndexerProgressMonitor {
    private static final Logger log = LoggerFactory.make();
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private final AtomicLong documentsBuiltCounter = new AtomicLong();
    private final AtomicLong totalCounter = new AtomicLong();
    private final AtomicLong entitiesLoadedCounter = new AtomicLong();
    private final String registeredName;

    public IndexingProgressMonitor() {
        String name = "org.hibernate.search.jmx:type=IndexingProgressMBean";
        if (JMXRegistrar.isNameRegistered(name)) {
            name = name + "@" + Integer.toHexString(this.hashCode());
        }
        this.registeredName = JMXRegistrar.registerMBean(this, name);
    }

    public final void documentsAdded(long increment) {
        this.documentsDoneCounter.addAndGet(increment);
    }

    public final void documentsBuilt(int number) {
        this.documentsBuiltCounter.addAndGet(number);
    }

    public final void entitiesLoaded(int size) {
        this.entitiesLoadedCounter.addAndGet(size);
    }

    public final void addToTotalCount(long count) {
        this.totalCounter.addAndGet(count);
    }

    public final void indexingCompleted() {
        log.info("Indexing completed. Reindexed {} entities. Unregistering MBean from server", (Object)this.totalCounter.get());
        JMXRegistrar.unRegisterMBean(this.registeredName);
    }

    public final long getLoadedEntitiesCount() {
        return this.entitiesLoadedCounter.get();
    }

    public final long getDocumentsAddedCount() {
        return this.documentsDoneCounter.get();
    }

    public final long getNumberOfEntitiesToIndex() {
        return this.totalCounter.get();
    }
}

