/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.query.dsl.v2.BooleanJunction;
import org.hibernate.search.query.dsl.v2.MustJunction;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;

class BooleanQueryBuilder
implements MustJunction {
    private final List<BooleanClause> clauses = new ArrayList<BooleanClause>(5);
    private final QueryCustomizer queryCustomizer = new QueryCustomizer();

    BooleanQueryBuilder() {
    }

    public BooleanJunction not() {
        int lastIndex = this.clauses.size() - 1;
        BooleanClause last = this.clauses.get(lastIndex);
        if (!last.getOccur().equals(BooleanClause.Occur.MUST)) {
            throw new AssertionFailure("Cannot negate class: " + last.getOccur());
        }
        this.clauses.set(lastIndex, new BooleanClause(last.getQuery(), BooleanClause.Occur.MUST_NOT));
        return this;
    }

    public BooleanJunction should(Query query) {
        this.clauses.add(new BooleanClause(query, BooleanClause.Occur.SHOULD));
        return this;
    }

    public MustJunction must(Query query) {
        this.clauses.add(new BooleanClause(query, BooleanClause.Occur.MUST));
        return this;
    }

    public MustJunction boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    public MustJunction constantScore() {
        this.queryCustomizer.constantScore();
        return this;
    }

    public MustJunction filter(Filter filter) {
        this.queryCustomizer.filter(filter);
        return this;
    }

    public Query createQuery() {
        int nbrOfClauses = this.clauses.size();
        if (nbrOfClauses == 0) {
            throw new AssertionFailure("Cannot create an empty boolean query");
        }
        if (nbrOfClauses == 1) {
            BooleanClause uniqueClause = this.clauses.get(0);
            if (uniqueClause.getOccur().equals(BooleanClause.Occur.MUST_NOT)) {
                this.should((Query)new MatchAllDocsQuery());
            } else {
                return this.queryCustomizer.setWrappedQuery(uniqueClause.getQuery()).createQuery();
            }
        }
        BooleanQuery query = new BooleanQuery();
        for (BooleanClause clause : this.clauses) {
            query.add(clause);
        }
        return this.queryCustomizer.setWrappedQuery((Query)query).createQuery();
    }
}

