/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Properties;
import org.apache.lucene.search.Similarity;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.impl.DefaultMutableEntityIndexBinding;
import org.hibernate.search.engine.impl.DynamicShardingEntityIndexBinding;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class EntityIndexBindingFactory {
    private static final Log log = LoggerFactory.make();

    private EntityIndexBindingFactory() {
    }

    public static <T, U> MutableEntityIndexBinding<T> buildEntityIndexBinder(Class<T> type, IndexManager[] providers, IndexShardingStrategy shardingStrategy, ShardIdentifierProvider shardIdentifierProvider, Similarity similarity, EntityIndexingInterceptor<U> interceptor, boolean isDynamicSharding, Properties properties, String rootDirectoryProviderName, WorkerBuildContext context, IndexManagerHolder indexManagerHolder, IndexManagerFactory indexManagerFactory) {
        if (!isDynamicSharding && providers.length == 0) {
            throw log.entityWithNoShard(type);
        }
        EntityIndexingInterceptor<U> safeInterceptor = interceptor;
        if (isDynamicSharding) {
            return new DynamicShardingEntityIndexBinding<U>(shardIdentifierProvider, similarity, safeInterceptor, properties, indexManagerFactory, context.getUninitializedSearchFactory(), indexManagerHolder, rootDirectoryProviderName);
        }
        return new DefaultMutableEntityIndexBinding<U>(shardingStrategy, similarity, providers, safeInterceptor);
    }

    public static <T> MutableEntityIndexBinding<T> copyEntityIndexBindingReplacingSimilarity(EntityIndexBinding entityMapping, Similarity entitySimilarity) {
        EntityIndexingInterceptor<?> interceptor = entityMapping.getEntityIndexingInterceptor();
        boolean isDynamicSharding = entityMapping instanceof DynamicShardingEntityIndexBinding;
        MutableEntityIndexBinding<?> newMapping = isDynamicSharding ? ((DynamicShardingEntityIndexBinding)entityMapping).cloneWithSimilarity(entitySimilarity) : new DefaultMutableEntityIndexBinding(entityMapping.getSelectionStrategy(), entitySimilarity, entityMapping.getIndexManagers(), interceptor);
        DocumentBuilderIndexedEntity<?> documentBuilder = entityMapping.getDocumentBuilder();
        newMapping.setDocumentBuilderIndexedEntity(documentBuilder);
        return newMapping;
    }
}

