/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.jcache.internal.JCacheAccessImpl;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.cache.spi.support.StorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class JCacheRegionFactory
extends RegionFactoryTemplate {
    private final CacheKeysFactory cacheKeysFactory;
    private volatile CacheManager cacheManager;

    public JCacheRegionFactory() {
        this((CacheKeysFactory)DefaultCacheKeysFactory.INSTANCE);
    }

    public JCacheRegionFactory(CacheKeysFactory cacheKeysFactory) {
        this.cacheKeysFactory = cacheKeysFactory;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected CacheKeysFactory getImplicitCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    protected DomainDataStorageAccess createDomainDataStorageAccess(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return new JCacheAccessImpl(this.getOrCreateCache(regionConfig.getRegionName(), buildingContext.getSessionFactory()));
    }

    protected Cache<Object, Object> getOrCreateCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        Cache cache = this.cacheManager.getCache(qualifiedRegionName);
        if (cache == null) {
            return this.createCache(qualifiedRegionName);
        }
        return cache;
    }

    protected Cache<Object, Object> createCache(String regionName) {
        throw new CacheException("On-the-fly creation of JCache Cache objects is not supported [" + regionName + "]");
    }

    protected StorageAccess createQueryResultsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new JCacheAccessImpl(this.getOrCreateCache(regionName, sessionFactory));
    }

    protected StorageAccess createTimestampsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new JCacheAccessImpl(this.getOrCreateCache(regionName, sessionFactory));
    }

    protected boolean isStarted() {
        return super.isStarted() && this.cacheManager != null;
    }

    protected void prepareForUse(SessionFactoryOptions settings, Map configValues) {
        this.cacheManager = this.resolveCacheManager(settings, configValues);
        if (this.cacheManager == null) {
            throw new CacheException("Could not locate/create CacheManager");
        }
    }

    protected CacheManager resolveCacheManager(SessionFactoryOptions settings, Map properties) {
        CacheManager cacheManager;
        Object explicitCacheManager = properties.get("hibernate.javax.cache.cache_manager");
        if (explicitCacheManager != null) {
            return this.useExplicitCacheManager(settings, explicitCacheManager);
        }
        CachingProvider cachingProvider = this.getCachingProvider(properties);
        String cacheManagerUri = this.getProp(properties, "hibernate.javax.cache.uri");
        if (cacheManagerUri != null) {
            URI uri;
            try {
                uri = new URI(cacheManagerUri);
            }
            catch (URISyntaxException e) {
                throw new CacheException("Couldn't create URI from " + cacheManagerUri, (Throwable)e);
            }
            cacheManager = cachingProvider.getCacheManager(uri, cachingProvider.getDefaultClassLoader());
        } else {
            cacheManager = cachingProvider.getCacheManager();
        }
        return cacheManager;
    }

    private String getProp(Map properties, String prop) {
        return properties != null ? (String)properties.get(prop) : null;
    }

    protected CachingProvider getCachingProvider(Map properties) {
        String provider = this.getProp(properties, "hibernate.javax.cache.provider");
        CachingProvider cachingProvider = provider != null ? Caching.getCachingProvider((String)provider) : Caching.getCachingProvider();
        return cachingProvider;
    }

    private CacheManager useExplicitCacheManager(SessionFactoryOptions settings, Object setting) {
        if (setting instanceof CacheManager) {
            return (CacheManager)setting;
        }
        Class cacheManagerClass = setting instanceof Class ? (Class)setting : ((ClassLoaderService)settings.getServiceRegistry().getService(ClassLoaderService.class)).classForName(setting.toString());
        try {
            return (CacheManager)cacheManagerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CacheException("Could not use explicit CacheManager : " + setting);
        }
    }

    protected void releaseFromUse() {
        try {
            this.cacheManager.close();
        }
        finally {
            this.cacheManager = null;
        }
    }
}

