/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class BetweenAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;
    private Object lo;
    private Object hi;

    public BetweenAuditExpression(PropertyNameGetter propertyNameGetter, Object lo, Object hi) {
        this.propertyNameGetter = propertyNameGetter;
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public void addToQuery(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, this.propertyNameGetter);
        CriteriaTools.checkPropertyNotARelation(enversService, entityName, propertyName);
        Parameters subParams = parameters.addSubParameters("and");
        subParams.addWhereWithParam(propertyName, ">=", this.lo);
        subParams.addWhereWithParam(propertyName, "<=", this.hi);
    }
}

