/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.internal.schemagen.SqlScriptInput;
import org.hibernate.jpa.internal.schemagen.SqlScriptReaderInput;
import org.jboss.logging.Logger;

class SqlScriptFileInput
extends SqlScriptReaderInput
implements SqlScriptInput {
    private static final Logger log = Logger.getLogger(SqlScriptFileInput.class);

    public SqlScriptFileInput(String fileUrl) {
        super(SqlScriptFileInput.toFileReader(fileUrl));
    }

    @Override
    public void release() {
        try {
            this.reader().close();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to close file reader for generation script source");
        }
    }

    private static Reader toFileReader(String fileUrl) {
        File file = new File(fileUrl);
        if (!file.exists()) {
            log.warnf("Specified schema generation script file [%s] did not exist for reading", (Object)fileUrl);
            return new Reader(){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    return -1;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        try {
            return new FileReader(file);
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to open specified script target file [" + fileUrl + "] for reading", (Throwable)e);
        }
    }
}

