/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.polyglot.HostFieldDesc;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=HostObject.class)
final class HostObjectFactory {
    HostObjectFactory() {
    }

    @GeneratedBy(value=HostObject.IsArrayNode.class)
    static final class IsArrayNodeGen
    extends HostObject.IsArrayNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private boolean isArrayAccess_;

        private IsArrayNodeGen() {
        }

        @Override
        public boolean execute(HostObject arg0Value) {
            int state = this.state_;
            if (state != 0) {
                return this.doDefault(arg0Value, this.isArrayAccess_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(HostObject arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.isArrayAccess_ = arg0Value.getHostClassCache().isArrayAccess();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doDefault(arg0Value, this.isArrayAccess_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static HostObject.IsArrayNode create() {
            return new IsArrayNodeGen();
        }

        public static HostObject.IsArrayNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.IsArrayNode.class)
        private static final class Uncached
        extends HostObject.IsArrayNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean execute(HostObject arg0Value) {
                return this.doDefault(arg0Value, arg0Value.getHostClassCache().isArrayAccess());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=HostObject.IsListNode.class)
    static final class IsListNodeGen
    extends HostObject.IsListNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private boolean isListAccess_;

        private IsListNodeGen() {
        }

        @Override
        public boolean execute(HostObject arg0Value) {
            int state = this.state_;
            if (state != 0) {
                return this.doDefault(arg0Value, this.isListAccess_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(HostObject arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.isListAccess_ = arg0Value.getHostClassCache().isListAccess();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doDefault(arg0Value, this.isListAccess_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static HostObject.IsListNode create() {
            return new IsListNodeGen();
        }

        public static HostObject.IsListNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.IsListNode.class)
        private static final class Uncached
        extends HostObject.IsListNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean execute(HostObject arg0Value) {
                return this.doDefault(arg0Value, arg0Value.getHostClassCache().isListAccess());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=HostObject.WriteFieldNode.class)
    static final class WriteFieldNodeGen
    extends HostObject.WriteFieldNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private CachedData cached_cache;
        @Node.Child
        private ToHostNode uncached_toHost_;

        private WriteFieldNodeGen() {
        }

        @Override
        @ExplodeLoop
        public void execute(HostFieldDesc arg0Value, HostObject arg1Value, Object arg2Value) throws UnsupportedTypeException, UnknownIdentifierException {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg0Value == s1_.cachedField_) {
                            HostObject.WriteFieldNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedField_, s1_.toHost_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    HostObject.WriteFieldNode.doUncached(arg0Value, arg1Value, arg2Value, this.uncached_toHost_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(HostFieldDesc arg0Value, HostObject arg1Value, Object arg2Value) throws UnsupportedTypeException, UnknownIdentifierException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg0Value != s1_.cachedField_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = super.insert(new CachedData(this.cached_cache));
                        s1_.cachedField_ = arg0Value;
                        s1_.toHost_ = s1_.insertAccessor(ToHostNodeGen.create());
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        HostObject.WriteFieldNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedField_, s1_.toHost_);
                        return;
                    }
                }
                this.uncached_toHost_ = super.insert(ToHostNodeGen.create());
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                HostObject.WriteFieldNode.doUncached(arg0Value, arg1Value, arg2Value, this.uncached_toHost_);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.WriteFieldNode create() {
            return new WriteFieldNodeGen();
        }

        public static HostObject.WriteFieldNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.WriteFieldNode.class)
        private static final class Uncached
        extends HostObject.WriteFieldNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(HostFieldDesc arg0Value, HostObject arg1Value, Object arg2Value) throws UnsupportedTypeException, UnknownIdentifierException {
                HostObject.WriteFieldNode.doUncached(arg0Value, arg1Value, arg2Value, ToHostNodeGen.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=HostObject.WriteFieldNode.class)
        private static final class CachedData
        extends Node {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            HostFieldDesc cachedField_;
            @Node.Child
            ToHostNode toHost_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }
        }
    }

    @GeneratedBy(value=HostObject.ReadFieldNode.class)
    static final class ReadFieldNodeGen
    extends HostObject.ReadFieldNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private CachedData cached_cache;
        @Node.Child
        private PolyglotLanguageContext.ToGuestValueNode uncached_toGuest_;

        private ReadFieldNodeGen() {
        }

        @Override
        @ExplodeLoop
        public Object execute(HostFieldDesc arg0Value, HostObject arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg0Value == s1_.cachedField_) {
                            return HostObject.ReadFieldNode.doCached(arg0Value, arg1Value, s1_.cachedField_, s1_.toGuest_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return HostObject.ReadFieldNode.doUncached(arg0Value, arg1Value, this.uncached_toGuest_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(HostFieldDesc arg0Value, HostObject arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg0Value != s1_.cachedField_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = super.insert(new CachedData(this.cached_cache));
                        s1_.cachedField_ = arg0Value;
                        s1_.toGuest_ = s1_.insertAccessor(PolyglotLanguageContextFactory.ToGuestValueNodeGen.create());
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = HostObject.ReadFieldNode.doCached(arg0Value, arg1Value, s1_.cachedField_, s1_.toGuest_);
                        return object;
                    }
                }
                this.uncached_toGuest_ = super.insert(PolyglotLanguageContextFactory.ToGuestValueNodeGen.create());
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Object object = HostObject.ReadFieldNode.doUncached(arg0Value, arg1Value, this.uncached_toGuest_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.ReadFieldNode create() {
            return new ReadFieldNodeGen();
        }

        public static HostObject.ReadFieldNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.ReadFieldNode.class)
        private static final class Uncached
        extends HostObject.ReadFieldNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object execute(HostFieldDesc arg0Value, HostObject arg1Value) {
                return HostObject.ReadFieldNode.doUncached(arg0Value, arg1Value, PolyglotLanguageContextFactory.ToGuestValueNodeGen.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=HostObject.ReadFieldNode.class)
        private static final class CachedData
        extends Node {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            HostFieldDesc cachedField_;
            @Node.Child
            PolyglotLanguageContext.ToGuestValueNode toGuest_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }
        }
    }

    @GeneratedBy(value=HostObject.LookupMethodNode.class)
    static final class LookupMethodNodeGen
    extends HostObject.LookupMethodNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private LookupMethodNodeGen() {
        }

        @Override
        @ExplodeLoop
        public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg3Value == s1_.cachedStatic_ && arg1Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg2Value)) {
                            return this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedMethod_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HostMethodDesc executeAndSpecialize(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (!(s1_ == null || arg3Value == s1_.cachedStatic_ && arg1Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg2Value))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedStatic_ = arg3Value;
                        s1_.cachedClazz_ = arg1Value;
                        s1_.cachedName_ = arg2Value;
                        s1_.cachedMethod_ = this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        HostMethodDesc hostMethodDesc = this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedMethod_);
                        return hostMethodDesc;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                HostMethodDesc hostMethodDesc = this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                return hostMethodDesc;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.LookupMethodNode create() {
            return new LookupMethodNodeGen();
        }

        public static HostObject.LookupMethodNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.LookupMethodNode.class)
        private static final class Uncached
        extends HostObject.LookupMethodNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
                return this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=HostObject.LookupMethodNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            boolean cachedStatic_;
            @CompilerDirectives.CompilationFinal
            Class<?> cachedClazz_;
            @CompilerDirectives.CompilationFinal
            String cachedName_;
            @CompilerDirectives.CompilationFinal
            HostMethodDesc cachedMethod_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=HostObject.LookupInnerClassNode.class)
    static final class LookupInnerClassNodeGen
    extends HostObject.LookupInnerClassNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private LookupInnerClassNodeGen() {
        }

        @Override
        @ExplodeLoop
        public Class<?> execute(Class<?> arg0Value, String arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg0Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg1Value)) {
                            return this.doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedInnerClass_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.doUncached(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> executeAndSpecialize(Class<?> arg0Value, String arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (!(s1_ == null || arg0Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg1Value))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedClazz_ = arg0Value;
                        s1_.cachedName_ = arg1Value;
                        s1_.cachedInnerClass_ = this.doUncached(arg0Value, arg1Value);
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Class<?> clazz = this.doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedInnerClass_);
                        return clazz;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Class<?> clazz = this.doUncached(arg0Value, arg1Value);
                return clazz;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.LookupInnerClassNode create() {
            return new LookupInnerClassNodeGen();
        }

        public static HostObject.LookupInnerClassNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.LookupInnerClassNode.class)
        private static final class Uncached
        extends HostObject.LookupInnerClassNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Class<?> execute(Class<?> arg0Value, String arg1Value) {
                return this.doUncached(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=HostObject.LookupInnerClassNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            Class<?> cachedClazz_;
            @CompilerDirectives.CompilationFinal
            String cachedName_;
            @CompilerDirectives.CompilationFinal
            Class<?> cachedInnerClass_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=HostObject.LookupFunctionalMethodNode.class)
    static final class LookupFunctionalMethodNodeGen
    extends HostObject.LookupFunctionalMethodNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private LookupFunctionalMethodNodeGen() {
        }

        @Override
        @ExplodeLoop
        public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg1Value == s1_.cachedClazz_) {
                            return this.doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedMethod_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return HostObject.LookupFunctionalMethodNode.doUncached(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HostMethodDesc executeAndSpecialize(HostObject arg0Value, Class<?> arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg1Value != s1_.cachedClazz_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedClazz_ = arg1Value;
                        s1_.cachedMethod_ = HostObject.LookupFunctionalMethodNode.doUncached(arg0Value, arg1Value);
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        HostMethodDesc hostMethodDesc = this.doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedMethod_);
                        return hostMethodDesc;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                HostMethodDesc hostMethodDesc = HostObject.LookupFunctionalMethodNode.doUncached(arg0Value, arg1Value);
                return hostMethodDesc;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.LookupFunctionalMethodNode create() {
            return new LookupFunctionalMethodNodeGen();
        }

        public static HostObject.LookupFunctionalMethodNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.LookupFunctionalMethodNode.class)
        private static final class Uncached
        extends HostObject.LookupFunctionalMethodNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value) {
                return HostObject.LookupFunctionalMethodNode.doUncached(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=HostObject.LookupFunctionalMethodNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            Class<?> cachedClazz_;
            @CompilerDirectives.CompilationFinal
            HostMethodDesc cachedMethod_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=HostObject.LookupFieldNode.class)
    static final class LookupFieldNodeGen
    extends HostObject.LookupFieldNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private LookupFieldNodeGen() {
        }

        @Override
        @ExplodeLoop
        public HostFieldDesc execute(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg3Value == s1_.cachedStatic_ && arg1Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg2Value)) {
                            return this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedField_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HostFieldDesc executeAndSpecialize(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (!(s1_ == null || arg3Value == s1_.cachedStatic_ && arg1Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg2Value))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedStatic_ = arg3Value;
                        s1_.cachedClazz_ = arg1Value;
                        s1_.cachedName_ = arg2Value;
                        s1_.cachedField_ = this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        HostFieldDesc hostFieldDesc = this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedField_);
                        return hostFieldDesc;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                HostFieldDesc hostFieldDesc = this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                return hostFieldDesc;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.LookupFieldNode create() {
            return new LookupFieldNodeGen();
        }

        public static HostObject.LookupFieldNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.LookupFieldNode.class)
        private static final class Uncached
        extends HostObject.LookupFieldNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public HostFieldDesc execute(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
                return this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=HostObject.LookupFieldNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            boolean cachedStatic_;
            @CompilerDirectives.CompilationFinal
            Class<?> cachedClazz_;
            @CompilerDirectives.CompilationFinal
            String cachedName_;
            @CompilerDirectives.CompilationFinal
            HostFieldDesc cachedField_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=HostObject.LookupConstructorNode.class)
    static final class LookupConstructorNodeGen
    extends HostObject.LookupConstructorNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private LookupConstructorNodeGen() {
        }

        @Override
        @ExplodeLoop
        public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg1Value == s1_.cachedClazz_) {
                            return this.doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedMethod_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.doUncached(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HostMethodDesc executeAndSpecialize(HostObject arg0Value, Class<?> arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg1Value != s1_.cachedClazz_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedClazz_ = arg1Value;
                        s1_.cachedMethod_ = this.doUncached(arg0Value, arg1Value);
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        HostMethodDesc hostMethodDesc = this.doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedMethod_);
                        return hostMethodDesc;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                HostMethodDesc hostMethodDesc = this.doUncached(arg0Value, arg1Value);
                return hostMethodDesc;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.LookupConstructorNode create() {
            return new LookupConstructorNodeGen();
        }

        public static HostObject.LookupConstructorNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.LookupConstructorNode.class)
        private static final class Uncached
        extends HostObject.LookupConstructorNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value) {
                return this.doUncached(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=HostObject.LookupConstructorNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            Class<?> cachedClazz_;
            @CompilerDirectives.CompilationFinal
            HostMethodDesc cachedMethod_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=HostObject.ArrayGet.class)
    static final class ArrayGetNodeGen
    extends HostObject.ArrayGet {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ArrayGetNodeGen() {
        }

        @Override
        protected Object execute(Object arg0Value, int arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value instanceof boolean[]) {
                    boolean[] arg0Value_ = (boolean[])arg0Value;
                    return HostObject.ArrayGet.doBoolean(arg0Value_, arg1Value);
                }
                if ((state & 2) != 0 && arg0Value instanceof byte[]) {
                    byte[] arg0Value_ = (byte[])arg0Value;
                    return HostObject.ArrayGet.doByte(arg0Value_, arg1Value);
                }
                if ((state & 4) != 0 && arg0Value instanceof short[]) {
                    short[] arg0Value_ = (short[])arg0Value;
                    return HostObject.ArrayGet.doShort(arg0Value_, arg1Value);
                }
                if ((state & 8) != 0 && arg0Value instanceof char[]) {
                    char[] arg0Value_ = (char[])arg0Value;
                    return Character.valueOf(HostObject.ArrayGet.doChar(arg0Value_, arg1Value));
                }
                if ((state & 0x10) != 0 && arg0Value instanceof int[]) {
                    int[] arg0Value_ = (int[])arg0Value;
                    return HostObject.ArrayGet.doInt(arg0Value_, arg1Value);
                }
                if ((state & 0x20) != 0 && arg0Value instanceof long[]) {
                    long[] arg0Value_ = (long[])arg0Value;
                    return HostObject.ArrayGet.doLong(arg0Value_, arg1Value);
                }
                if ((state & 0x40) != 0 && arg0Value instanceof float[]) {
                    float[] arg0Value_ = (float[])arg0Value;
                    return Float.valueOf(HostObject.ArrayGet.doFloat(arg0Value_, arg1Value));
                }
                if ((state & 0x80) != 0 && arg0Value instanceof double[]) {
                    double[] arg0Value_ = (double[])arg0Value;
                    return HostObject.ArrayGet.doDouble(arg0Value_, arg1Value);
                }
                if ((state & 0x100) != 0 && arg0Value instanceof Object[]) {
                    Object[] arg0Value_ = (Object[])arg0Value;
                    return HostObject.ArrayGet.doObject(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, int arg1Value) {
            int state = this.state_;
            if (arg0Value instanceof boolean[]) {
                boolean[] arg0Value_ = (boolean[])arg0Value;
                this.state_ = state |= 1;
                return HostObject.ArrayGet.doBoolean(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof byte[]) {
                byte[] arg0Value_ = (byte[])arg0Value;
                this.state_ = state |= 2;
                return HostObject.ArrayGet.doByte(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof short[]) {
                short[] arg0Value_ = (short[])arg0Value;
                this.state_ = state |= 4;
                return HostObject.ArrayGet.doShort(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof char[]) {
                char[] arg0Value_ = (char[])arg0Value;
                this.state_ = state |= 8;
                return Character.valueOf(HostObject.ArrayGet.doChar(arg0Value_, arg1Value));
            }
            if (arg0Value instanceof int[]) {
                int[] arg0Value_ = (int[])arg0Value;
                this.state_ = state |= 0x10;
                return HostObject.ArrayGet.doInt(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof long[]) {
                long[] arg0Value_ = (long[])arg0Value;
                this.state_ = state |= 0x20;
                return HostObject.ArrayGet.doLong(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof float[]) {
                float[] arg0Value_ = (float[])arg0Value;
                this.state_ = state |= 0x40;
                return Float.valueOf(HostObject.ArrayGet.doFloat(arg0Value_, arg1Value));
            }
            if (arg0Value instanceof double[]) {
                double[] arg0Value_ = (double[])arg0Value;
                this.state_ = state |= 0x80;
                return HostObject.ArrayGet.doDouble(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof Object[]) {
                Object[] arg0Value_ = (Object[])arg0Value;
                this.state_ = state |= 0x100;
                return HostObject.ArrayGet.doObject(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.ArrayGet create() {
            return new ArrayGetNodeGen();
        }

        public static HostObject.ArrayGet getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.ArrayGet.class)
        private static final class Uncached
        extends HostObject.ArrayGet {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected Object execute(Object arg0Value, int arg1Value) {
                if (arg0Value instanceof boolean[]) {
                    boolean[] arg0Value_ = (boolean[])arg0Value;
                    return HostObject.ArrayGet.doBoolean(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof byte[]) {
                    byte[] arg0Value_ = (byte[])arg0Value;
                    return HostObject.ArrayGet.doByte(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof short[]) {
                    short[] arg0Value_ = (short[])arg0Value;
                    return HostObject.ArrayGet.doShort(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof char[]) {
                    char[] arg0Value_ = (char[])arg0Value;
                    return Character.valueOf(HostObject.ArrayGet.doChar(arg0Value_, arg1Value));
                }
                if (arg0Value instanceof int[]) {
                    int[] arg0Value_ = (int[])arg0Value;
                    return HostObject.ArrayGet.doInt(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof long[]) {
                    long[] arg0Value_ = (long[])arg0Value;
                    return HostObject.ArrayGet.doLong(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof float[]) {
                    float[] arg0Value_ = (float[])arg0Value;
                    return Float.valueOf(HostObject.ArrayGet.doFloat(arg0Value_, arg1Value));
                }
                if (arg0Value instanceof double[]) {
                    double[] arg0Value_ = (double[])arg0Value;
                    return HostObject.ArrayGet.doDouble(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof Object[]) {
                    Object[] arg0Value_ = (Object[])arg0Value;
                    return HostObject.ArrayGet.doObject(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=HostObject.ArraySet.class)
    static final class ArraySetNodeGen
    extends HostObject.ArraySet {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ArraySetNodeGen() {
        }

        @Override
        protected void execute(Object arg0Value, int arg1Value, Object arg2Value) {
            int state = this.state_;
            if (state != 0) {
                Object[] arg0Value_;
                if ((state & 1) != 0 && arg0Value instanceof boolean[]) {
                    arg0Value_ = (boolean[])arg0Value;
                    if (arg2Value instanceof Boolean) {
                        boolean arg2Value_ = (Boolean)arg2Value;
                        HostObject.ArraySet.doBoolean(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 2) != 0 && arg0Value instanceof byte[]) {
                    arg0Value_ = (byte[])arg0Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (Byte)arg2Value;
                        HostObject.ArraySet.doByte((byte[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 4) != 0 && arg0Value instanceof short[]) {
                    arg0Value_ = (short[])arg0Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (Short)arg2Value;
                        HostObject.ArraySet.doShort((short[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 8) != 0 && arg0Value instanceof char[]) {
                    arg0Value_ = (char[])arg0Value;
                    if (arg2Value instanceof Character) {
                        char arg2Value_ = ((Character)arg2Value).charValue();
                        HostObject.ArraySet.doChar((char[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0x10) != 0 && arg0Value instanceof int[]) {
                    arg0Value_ = (int[])arg0Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (Integer)arg2Value;
                        HostObject.ArraySet.doInt((int[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0x20) != 0 && arg0Value instanceof long[]) {
                    arg0Value_ = (long[])arg0Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        HostObject.ArraySet.doLong((long[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0x40) != 0 && arg0Value instanceof float[]) {
                    arg0Value_ = (float[])arg0Value;
                    if (arg2Value instanceof Float) {
                        float arg2Value_ = ((Float)arg2Value).floatValue();
                        HostObject.ArraySet.doFloat((float[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0x80) != 0 && arg0Value instanceof double[]) {
                    arg0Value_ = (double[])arg0Value;
                    if (arg2Value instanceof Double) {
                        double arg2Value_ = (Double)arg2Value;
                        HostObject.ArraySet.doDouble((double[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0x100) != 0 && arg0Value instanceof Object[]) {
                    arg0Value_ = (Object[])arg0Value;
                    HostObject.ArraySet.doObject(arg0Value_, arg1Value, arg2Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(Object arg0Value, int arg1Value, Object arg2Value) {
            Object[] arg0Value_;
            int state = this.state_;
            if (arg0Value instanceof boolean[]) {
                arg0Value_ = (boolean[])arg0Value;
                if (arg2Value instanceof Boolean) {
                    boolean arg2Value_ = (Boolean)arg2Value;
                    this.state_ = state |= 1;
                    HostObject.ArraySet.doBoolean(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof byte[]) {
                arg0Value_ = (byte[])arg0Value;
                if (arg2Value instanceof Byte) {
                    byte arg2Value_ = (Byte)arg2Value;
                    this.state_ = state |= 2;
                    HostObject.ArraySet.doByte((byte[])arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof short[]) {
                arg0Value_ = (short[])arg0Value;
                if (arg2Value instanceof Short) {
                    short arg2Value_ = (Short)arg2Value;
                    this.state_ = state |= 4;
                    HostObject.ArraySet.doShort((short[])arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof char[]) {
                arg0Value_ = (char[])arg0Value;
                if (arg2Value instanceof Character) {
                    char arg2Value_ = ((Character)arg2Value).charValue();
                    this.state_ = state |= 8;
                    HostObject.ArraySet.doChar((char[])arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof int[]) {
                arg0Value_ = (int[])arg0Value;
                if (arg2Value instanceof Integer) {
                    int arg2Value_ = (Integer)arg2Value;
                    this.state_ = state |= 0x10;
                    HostObject.ArraySet.doInt((int[])arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof long[]) {
                arg0Value_ = (long[])arg0Value;
                if (arg2Value instanceof Long) {
                    long arg2Value_ = (Long)arg2Value;
                    this.state_ = state |= 0x20;
                    HostObject.ArraySet.doLong((long[])arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof float[]) {
                arg0Value_ = (float[])arg0Value;
                if (arg2Value instanceof Float) {
                    float arg2Value_ = ((Float)arg2Value).floatValue();
                    this.state_ = state |= 0x40;
                    HostObject.ArraySet.doFloat((float[])arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof double[]) {
                arg0Value_ = (double[])arg0Value;
                if (arg2Value instanceof Double) {
                    double arg2Value_ = (Double)arg2Value;
                    this.state_ = state |= 0x80;
                    HostObject.ArraySet.doDouble((double[])arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof Object[]) {
                arg0Value_ = (Object[])arg0Value;
                this.state_ = state |= 0x100;
                HostObject.ArraySet.doObject(arg0Value_, arg1Value, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostObject.ArraySet create() {
            return new ArraySetNodeGen();
        }

        public static HostObject.ArraySet getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=HostObject.ArraySet.class)
        private static final class Uncached
        extends HostObject.ArraySet {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Object arg0Value, int arg1Value, Object arg2Value) {
                Object[] arg0Value_;
                if (arg0Value instanceof boolean[]) {
                    arg0Value_ = (boolean[])arg0Value;
                    if (arg2Value instanceof Boolean) {
                        boolean arg2Value_ = (Boolean)arg2Value;
                        HostObject.ArraySet.doBoolean(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof byte[]) {
                    arg0Value_ = (byte[])arg0Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (Byte)arg2Value;
                        HostObject.ArraySet.doByte((byte[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof short[]) {
                    arg0Value_ = (short[])arg0Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (Short)arg2Value;
                        HostObject.ArraySet.doShort((short[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof char[]) {
                    arg0Value_ = (char[])arg0Value;
                    if (arg2Value instanceof Character) {
                        char arg2Value_ = ((Character)arg2Value).charValue();
                        HostObject.ArraySet.doChar((char[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof int[]) {
                    arg0Value_ = (int[])arg0Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (Integer)arg2Value;
                        HostObject.ArraySet.doInt((int[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof long[]) {
                    arg0Value_ = (long[])arg0Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        HostObject.ArraySet.doLong((long[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof float[]) {
                    arg0Value_ = (float[])arg0Value;
                    if (arg2Value instanceof Float) {
                        float arg2Value_ = ((Float)arg2Value).floatValue();
                        HostObject.ArraySet.doFloat((float[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof double[]) {
                    arg0Value_ = (double[])arg0Value;
                    if (arg2Value instanceof Double) {
                        double arg2Value_ = (Double)arg2Value;
                        HostObject.ArraySet.doDouble((double[])arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof Object[]) {
                    arg0Value_ = (Object[])arg0Value;
                    HostObject.ArraySet.doObject(arg0Value_, arg1Value, arg2Value);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }
}

