/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DynamicObject.class)
final class DynamicObjectGen {
    private DynamicObjectGen() {
    }

    static {
        LibraryExport.register(DynamicObject.class, new DynamicDispatchLibraryExports());
    }

    @GeneratedBy(value=DynamicObject.class)
    private static final class DynamicDispatchLibraryExports
    extends LibraryExport<DynamicDispatchLibrary> {
        private DynamicDispatchLibraryExports() {
            super(DynamicDispatchLibrary.class, DynamicObject.class, false);
        }

        @Override
        protected DynamicDispatchLibrary createUncached(Object receiver) {
            assert (receiver instanceof DynamicObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected DynamicDispatchLibrary createCached(Object receiver) {
            assert (receiver instanceof DynamicObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=DynamicObject.class)
        private static final class Uncached
        extends DynamicDispatchLibrary {
            private final Class<? extends DynamicObject> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((DynamicObject)receiver).getClass();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return receiver.getClass() == this.receiverClass_ && Uncached.accepts_(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object cast(Object receiver) {
                return (DynamicObject)receiver;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Class<?> dispatch(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return DynamicObject.Dispatch.doCachedTypeClass(arg0Value, arg0Value.getShape().getObjectType().getClass());
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return DynamicObject.Accepts.doCachedTypeClass(arg0Value, arg0Value.getShape().getObjectType().getClass());
            }
        }

        @GeneratedBy(value=DynamicObject.class)
        private static final class Cached
        extends DynamicDispatchLibrary {
            private final Class<? extends DynamicObject> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @CompilerDirectives.CompilationFinal
            private Shape cachedShape;
            @CompilerDirectives.CompilationFinal
            private Class<? extends ObjectType> cachedTypeClass;

            Cached(Object receiver) {
                this.receiverClass_ = ((DynamicObject)receiver).getClass();
            }

            @Override
            public Object cast(Object receiver) {
                return CompilerDirectives.castExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean accepts(Object receiver) {
                return receiver.getClass() == this.receiverClass_ && this.accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                DynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 3) != 0) {
                    if ((state & 1) != 0 && this.cachedShape == arg0Value.getShape()) {
                        return DynamicObject.Accepts.doCachedShape(arg0Value, this.cachedShape, this.cachedTypeClass);
                    }
                    if ((state & 2) != 0) {
                        return DynamicObject.Accepts.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.acceptsAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean acceptsAndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if ((exclude & 1) == 0) {
                        Shape accepts_cachedShape_cachedShape__;
                        boolean CachedShape_duplicateFound_ = false;
                        if ((state & 1) != 0 && this.cachedShape == arg0Value.getShape()) {
                            CachedShape_duplicateFound_ = true;
                        }
                        if (!CachedShape_duplicateFound_ && (accepts_cachedShape_cachedShape__ = arg0Value.getShape()) == arg0Value.getShape() && (state & 1) == 0) {
                            if (this.cachedShape == null) {
                                this.cachedShape = accepts_cachedShape_cachedShape__;
                            }
                            if (this.cachedTypeClass == null) {
                                this.cachedTypeClass = arg0Value.getShape().getObjectType().getClass();
                            }
                            this.state_ = state |= 1;
                            CachedShape_duplicateFound_ = true;
                        }
                        if (CachedShape_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            boolean bl = DynamicObject.Accepts.doCachedShape(arg0Value, this.cachedShape, this.cachedTypeClass);
                            return bl;
                        }
                    }
                    if (this.cachedTypeClass == null) {
                        this.cachedTypeClass = arg0Value.getShape().getObjectType().getClass();
                    }
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DynamicObject.Accepts.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 3 & (state & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Class<?> dispatch(Object arg0Value_) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 0xC) != 0) {
                    if ((state & 4) != 0 && this.cachedShape == arg0Value.getShape()) {
                        return DynamicObject.Dispatch.doCachedShape(arg0Value, this.cachedShape, this.cachedTypeClass);
                    }
                    if ((state & 8) != 0) {
                        return DynamicObject.Dispatch.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.dispatchAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Class<?> dispatchAndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if ((exclude & 2) == 0) {
                        Shape dispatch_cachedShape_cachedShape__;
                        boolean CachedShape_duplicateFound_ = false;
                        if ((state & 4) != 0 && this.cachedShape == arg0Value.getShape()) {
                            CachedShape_duplicateFound_ = true;
                        }
                        if (!CachedShape_duplicateFound_ && (dispatch_cachedShape_cachedShape__ = arg0Value.getShape()) == arg0Value.getShape() && (state & 4) == 0) {
                            if (this.cachedShape == null) {
                                this.cachedShape = dispatch_cachedShape_cachedShape__;
                            }
                            if (this.cachedTypeClass == null) {
                                this.cachedTypeClass = arg0Value.getShape().getObjectType().getClass();
                            }
                            this.state_ = state |= 4;
                            CachedShape_duplicateFound_ = true;
                        }
                        if (CachedShape_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            Class<?> clazz = DynamicObject.Dispatch.doCachedShape(arg0Value, this.cachedShape, this.cachedTypeClass);
                            return clazz;
                        }
                    }
                    if (this.cachedTypeClass == null) {
                        this.cachedTypeClass = arg0Value.getShape().getObjectType().getClass();
                    }
                    this.exclude_ = exclude |= 2;
                    state &= 0xFFFFFFFB;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Class<?> clazz = DynamicObject.Dispatch.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    return clazz;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

