/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.library;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.utilities.FinalBitSet;

public abstract class LibraryExport<T extends Library> {
    static final String GENERATED_CLASS_SUFFIX = "Gen";
    private final Class<?> receiverClass;
    private final Class<? extends T> library;
    private final boolean defaultExport;
    Class<?> registerClass;

    protected LibraryExport(Class<? extends T> library, Class<?> receiverClass, boolean defaultExport) {
        this.library = library;
        this.receiverClass = receiverClass;
        this.defaultExport = defaultExport;
    }

    protected abstract T createUncached(Object var1);

    protected abstract T createCached(Object var1);

    final boolean isDefaultExport() {
        return this.defaultExport;
    }

    final Class<?> getReceiverClass() {
        return this.receiverClass;
    }

    final Class<? extends T> getLibrary() {
        return this.library;
    }

    protected static <T extends Library> T createDelegate(LibraryFactory<T> factory, T delegate) {
        return factory.createDelegate(delegate);
    }

    protected static FinalBitSet createMessageBitSet(LibraryFactory<?> factory, String ... messageNames) {
        Message[] messages = new Message[messageNames.length];
        for (int i = 0; i < messageNames.length; ++i) {
            messages[i] = factory.nameToMessages.get(messageNames[i]);
        }
        return factory.createMessageBitSet(messages);
    }

    public final String toString() {
        return "LibraryExport[" + this.getClass().getAnnotation(GeneratedBy.class).value().getName() + "]";
    }

    public static <T extends Library> void register(Class<?> receiverClass, LibraryExport<?> ... libs) {
        LibraryFactory.ResolvedDispatch.register(receiverClass, libs);
    }

    protected static interface DelegateExport {
        public Object readDelegateExport(Object var1);

        public FinalBitSet getDelegateExportMessages();

        public Library getDelegateExportLibrary(Object var1);
    }
}

