/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;
import org.freehep.util.images.ImageHandler;

public class TestTransparency
extends TestingPanel {
    static Stroke stroke = new BasicStroke(5.0f, 1, 1);
    private Image image;
    private Color bkg = Color.ORANGE;
    static /* synthetic */ Class class$org$freehep$graphicsio$test$TestTransparency;

    public TestTransparency(String[] args) throws Exception {
        super(args);
        this.setName("Transparency");
        MediaTracker t = new MediaTracker(this);
        this.image = ImageHandler.getImage((String)"images/transparent-image.gif", (Class)(class$org$freehep$graphicsio$test$TestTransparency == null ? (class$org$freehep$graphicsio$test$TestTransparency = TestTransparency.class$("org.freehep.graphicsio.test.TestTransparency")) : class$org$freehep$graphicsio$test$TestTransparency));
        t.addImage(this.image, 0);
        try {
            t.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void paintComponent(Graphics g) {
        int n;
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        int numberOfImages = 16;
        int dalpha = 255 / (numberOfImages - 1);
        int imagesPerSide = (int)Math.sqrt(numberOfImages);
        int x0 = 10;
        int y0 = 10;
        int width = this.getWidth();
        int height = this.getHeight();
        int dw = (width - 2 * x0) / imagesPerSide;
        int dh = (height - 2 * y0) / imagesPerSide;
        int x = x0;
        int y = y0;
        vg.setBackground(this.bkg);
        vg.clearRect(0, 0, width, height);
        BufferedImage[] bi = new BufferedImage[numberOfImages];
        for (n = 0; n < numberOfImages; ++n) {
            bi[n] = new BufferedImage(this.image.getWidth(this), this.image.getHeight(this), 2);
            bi[n].createGraphics().drawImage(this.image, 0, 0, this);
            for (int j = 0; j < bi[n].getHeight(); ++j) {
                for (int i = 0; i < bi[n].getWidth(); ++i) {
                    int data = bi[n].getRGB(i, j);
                    if ((data >> 24 & 0xFF) != 0) continue;
                    data |= dalpha * n << 24;
                    bi[n].setRGB(i, j, data |= 0x8080);
                }
            }
        }
        n = 0;
        for (int i = 0; i < imagesPerSide; ++i) {
            for (int j = 0; j < imagesPerSide; ++j) {
                vg.drawImage((Image)bi[n], x, y, dw, dh, (ImageObserver)this);
                ++n;
                x += dw;
            }
            x = x0;
            y += dh;
        }
    }

    public static void main(String[] args) throws Exception {
        new TestTransparency(args).runTest();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

