/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.cockroachdb;

import java.sql.Connection;
import java.util.Properties;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.authentication.postgres.PgpassFileReader;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.DefaultExecutionStrategy;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.ExecutionTemplate;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeMessage;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.database.cockroachdb.CockroachDBParser;
import org.flywaydb.database.cockroachdb.CockroachDBRetryingStrategy;
import org.flywaydb.database.cockroachdb.CockroachRetryingTransactionalExecutionTemplate;

public class CockroachDBDatabaseType
extends BaseDatabaseType {
    private static final Log LOG = LogFactory.getLog(CockroachDBDatabaseType.class);

    public String getName() {
        return "CockroachDB";
    }

    public int getNullType() {
        return 0;
    }

    public boolean supportsReadOnlyTransactions() {
        return false;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:postgresql:") || url.startsWith("jdbc:p6spy:postgresql:");
    }

    public int getPriority() {
        return 1;
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:postgresql:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "org.postgresql.Driver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        if (databaseProductName.startsWith("PostgreSQL")) {
            String selectVersionQueryOutput = BaseDatabaseType.getSelectVersionOutput((Connection)connection);
            return selectVersionQueryOutput.contains("CockroachDB");
        }
        return false;
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new CockroachDBDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new CockroachDBParser(configuration, parsingContext);
    }

    public DatabaseExecutionStrategy createExecutionStrategy(Connection connection) {
        if (connection == null) {
            return new DefaultExecutionStrategy();
        }
        return new CockroachDBRetryingStrategy();
    }

    public ExecutionTemplate createTransactionalExecutionTemplate(Connection connection, boolean rollbackOnException) {
        return new CockroachRetryingTransactionalExecutionTemplate(connection, rollbackOnException);
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("applicationName", "Flyway by Redgate");
    }

    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("user=");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("password=");
    }

    public boolean externalAuthPropertiesRequired(String url, String username, String password) {
        return super.externalAuthPropertiesRequired(url, username, password);
    }

    public Properties getExternalAuthProperties(String url, String username) {
        PgpassFileReader pgpassFileReader = new PgpassFileReader();
        if (pgpassFileReader.getPgpassFilePath() != null) {
            LOG.info(FlywayTeamsUpgradeMessage.generate((String)("pgpass file '" + pgpassFileReader.getPgpassFilePath() + "'"), (String)"use this for database authentication"));
        }
        return super.getExternalAuthProperties(url, username);
    }
}

