/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output.errors;

import java.util.Optional;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.output.errors.ErrorCause;
import org.flywaydb.core.api.output.errors.ErrorOutputItem;
import org.flywaydb.core.api.output.errors.ExceptionToErrorObjectConverter;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlErrorCode;

public class FlywaySqlExceptionToErrorObjectConverter
extends ExceptionToErrorObjectConverter<FlywaySqlException, FlywaySqlErrorOutputItem> {
    @Override
    public Class<FlywaySqlException> getSupportedExceptionType() {
        return FlywaySqlException.class;
    }

    @Override
    public FlywaySqlErrorOutputItem convert(FlywaySqlException exception) {
        return new FlywaySqlErrorOutputItem(exception.getErrorCode(), exception.getSubErrorCode(), exception.getSqlState(), exception.getSqlErrorCode(), Optional.ofNullable(exception.getMessage()).orElse("Error occurred"), this.getCause(exception).orElse(null));
    }

    public record FlywaySqlErrorOutputItem(ErrorCode errorCode, FlywaySqlErrorCode subErrorCode, String sqlState, Integer sqlErrorCode, String message, ErrorCause cause) implements ErrorOutputItem
    {
    }
}

