/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.NodeAttributes;
import org.elasticsearch.client.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.client.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class TransformStats {
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    public static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
    public static final ParseField NODE_FIELD = new ParseField("node", new String[0]);
    public static final ParseField STATS_FIELD = new ParseField("stats", new String[0]);
    public static final ParseField CHECKPOINTING_INFO_FIELD = new ParseField("checkpointing", new String[0]);
    public static final ConstructingObjectParser<TransformStats, Void> PARSER = new ConstructingObjectParser("data_frame_transform_state_and_stats_info", true, a -> new TransformStats((String)a[0], (State)((Object)((Object)a[1])), (String)a[2], (NodeAttributes)a[3], (TransformIndexerStats)a[4], (TransformCheckpointingInfo)a[5]));
    private final String id;
    private final String reason;
    private final State state;
    private final NodeAttributes node;
    private final TransformIndexerStats indexerStats;
    private final TransformCheckpointingInfo checkpointingInfo;

    public static TransformStats fromXContent(XContentParser parser) throws IOException {
        return (TransformStats)PARSER.parse(parser, null);
    }

    public TransformStats(String id, State state, String reason, NodeAttributes node, TransformIndexerStats stats, TransformCheckpointingInfo checkpointingInfo) {
        this.id = id;
        this.state = state;
        this.reason = reason;
        this.node = node;
        this.indexerStats = stats;
        this.checkpointingInfo = checkpointingInfo;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public String getReason() {
        return this.reason;
    }

    public NodeAttributes getNode() {
        return this.node;
    }

    public TransformIndexerStats getIndexerStats() {
        return this.indexerStats;
    }

    public TransformCheckpointingInfo getCheckpointingInfo() {
        return this.checkpointingInfo;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.reason, this.node, this.indexerStats, this.checkpointingInfo});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformStats that = (TransformStats)other;
        return Objects.equals(this.id, that.id) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.reason, that.reason) && Objects.equals(this.node, that.node) && Objects.equals(this.indexerStats, that.indexerStats) && Objects.equals(this.checkpointingInfo, that.checkpointingInfo);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> State.fromString(p.text()), STATE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> NodeAttributes.PARSER.apply(arg_0, arg_1), NODE_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> TransformIndexerStats.fromXContent(p), STATS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TransformCheckpointingInfo.fromXContent(p), CHECKPOINTING_INFO_FIELD);
    }

    public static enum State {
        STARTED,
        INDEXING,
        ABORTING,
        STOPPING,
        STOPPED,
        FAILED,
        WAITING;


        public static State fromString(String name) {
            return State.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

