/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public class MessageInputStream
extends InputStream
implements MessageAppender {
    private static final Logger LOG = Log.getLogger(MessageInputStream.class);
    private static final ByteBuffer EOF = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private final BlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final long timeoutMs;
    private ByteBuffer activeBuffer = null;

    public MessageInputStream(LogicalConnection connection) {
        this(connection, -1);
    }

    public MessageInputStream(LogicalConnection connection, int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public void appendFrame(ByteBuffer framePayload, boolean fin) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendMessage(ByteBuffer,{}): {}", new Object[]{fin, BufferUtil.toDetailString((ByteBuffer)framePayload)});
        }
        if (this.closed.get()) {
            return;
        }
        try {
            int capacity = framePayload.remaining();
            ByteBuffer copy = framePayload.isDirect() ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
            copy.put(framePayload).flip();
            this.buffers.put(copy);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            if (fin) {
                this.buffers.offer(EOF);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.buffers.offer(EOF);
            super.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void messageComplete() {
        LOG.debug("messageComplete()", new Object[0]);
        this.buffers.offer(EOF);
    }

    @Override
    public int read() throws IOException {
        LOG.debug("read()", new Object[0]);
        try {
            if (this.closed.get()) {
                return -1;
            }
            while (this.activeBuffer == null || !this.activeBuffer.hasRemaining()) {
                if (this.timeoutMs < 0L) {
                    this.activeBuffer = this.buffers.take();
                } else {
                    this.activeBuffer = this.buffers.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
                    if (this.activeBuffer == null) {
                        throw new IOException(String.format("Read timeout: %,dms expired", this.timeoutMs));
                    }
                }
                if (this.activeBuffer != EOF) continue;
                this.closed.set(true);
                return -1;
            }
            return this.activeBuffer.get();
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
            this.closed.set(true);
            return -1;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("reset() not supported");
    }
}

