/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;

public class URIUtil
implements Cloneable {
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTP_COLON = "http:";
    public static final String HTTPS = "https";
    public static final String HTTPS_COLON = "https:";
    public static final Charset __CHARSET;

    private URIUtil() {
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder buf = URIUtil.encodePath(null, path);
        return buf == null ? path : buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder encodePath(StringBuilder buf, String path) {
        byte[] bytes = null;
        if (buf == null) {
            block28: for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': {
                        buf = new StringBuilder(path.length() * 2);
                        break block28;
                    }
                    default: {
                        if (c <= '\u007f') continue block28;
                        bytes = path.getBytes(__CHARSET);
                        buf = new StringBuilder(path.length() * 2);
                        break block28;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            int i;
            if (bytes != null) {
                block29: for (i = 0; i < bytes.length; ++i) {
                    void c = bytes[i];
                    switch (c) {
                        case 37: {
                            buf.append("%25");
                            continue block29;
                        }
                        case 63: {
                            buf.append("%3F");
                            continue block29;
                        }
                        case 59: {
                            buf.append("%3B");
                            continue block29;
                        }
                        case 35: {
                            buf.append("%23");
                            continue block29;
                        }
                        case 34: {
                            buf.append("%22");
                            continue block29;
                        }
                        case 39: {
                            buf.append("%27");
                            continue block29;
                        }
                        case 60: {
                            buf.append("%3C");
                            continue block29;
                        }
                        case 62: {
                            buf.append("%3E");
                            continue block29;
                        }
                        case 32: {
                            buf.append("%20");
                            continue block29;
                        }
                        default: {
                            if (c < 0) {
                                buf.append('%');
                                TypeUtil.toHex((byte)c, (Appendable)buf);
                                continue block29;
                            }
                            buf.append((char)c);
                            continue block29;
                        }
                    }
                }
            } else {
                block30: for (i = 0; i < path.length(); ++i) {
                    char c = path.charAt(i);
                    switch (c) {
                        case '%': {
                            buf.append("%25");
                            continue block30;
                        }
                        case '?': {
                            buf.append("%3F");
                            continue block30;
                        }
                        case ';': {
                            buf.append("%3B");
                            continue block30;
                        }
                        case '#': {
                            buf.append("%23");
                            continue block30;
                        }
                        case '\"': {
                            buf.append("%22");
                            continue block30;
                        }
                        case '\'': {
                            buf.append("%27");
                            continue block30;
                        }
                        case '<': {
                            buf.append("%3C");
                            continue block30;
                        }
                        case '>': {
                            buf.append("%3E");
                            continue block30;
                        }
                        case ' ': {
                            buf.append("%20");
                            continue block30;
                        }
                        default: {
                            buf.append(c);
                            continue block30;
                        }
                    }
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder encodeString(StringBuilder buf, String path, String encode) {
        if (buf == null) {
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c != '%' && encode.indexOf(c) < 0) continue;
                buf = new StringBuilder(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c == '%' || encode.indexOf(c) >= 0) {
                    buf.append('%');
                    StringUtil.append(buf, (byte)(0xFF & c), 16);
                    continue;
                }
                buf.append(c);
            }
        }
        return buf;
    }

    public static String decodePath(String path) {
        if (path == null) {
            return null;
        }
        char[] chars = null;
        int n = 0;
        byte[] bytes = null;
        int b = 0;
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < len) {
                if (chars == null) {
                    chars = new char[len];
                    bytes = new byte[len];
                    path.getChars(0, i, chars, 0);
                }
                bytes[b++] = (byte)(0xFF & TypeUtil.parseInt(path, i + 1, 2, 16));
                i += 2;
                continue;
            }
            if (c == ';') {
                if (chars != null) break;
                chars = new char[len];
                path.getChars(0, i, chars, 0);
                n = i;
                break;
            }
            if (bytes == null) {
                ++n;
                continue;
            }
            if (b > 0) {
                String s = new String(bytes, 0, b, __CHARSET);
                s.getChars(0, s.length(), chars, n);
                n += s.length();
                b = 0;
            }
            chars[n++] = c;
        }
        if (chars == null) {
            return path;
        }
        if (b > 0) {
            String s = new String(bytes, 0, b, __CHARSET);
            s.getChars(0, s.length(), chars, n);
            n += s.length();
        }
        return new String(chars, 0, n);
    }

    public static String decodePath(byte[] buf, int offset, int length) {
        byte[] bytes = null;
        int n = 0;
        for (int i = 0; i < length; ++i) {
            byte b = buf[i + offset];
            if (b == 37 && i + 2 < length) {
                b = (byte)(0xFF & TypeUtil.parseInt(buf, i + offset + 1, 2, 16));
                i += 2;
            } else {
                if (b == 59) {
                    length = i;
                    break;
                }
                if (bytes == null) {
                    ++n;
                    continue;
                }
            }
            if (bytes == null) {
                bytes = new byte[length];
                for (int j = 0; j < n; ++j) {
                    bytes[j] = buf[j + offset];
                }
            }
            bytes[n++] = b;
        }
        if (bytes == null) {
            return new String(buf, offset, length, __CHARSET);
        }
        return new String(bytes, 0, n, __CHARSET);
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith(SLASH)) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith(SLASH)) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String parentPath(String p) {
        if (p == null || SLASH.equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int end = path.length();
        int start = path.lastIndexOf(47, end);
        block8: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (path.charAt(start + 1) == '.') break block8;
                    break;
                }
                case 3: {
                    if (path.charAt(start + 1) == '.' && path.charAt(start + 2) == '.') break block8;
                }
            }
            end = start;
            start = path.lastIndexOf(47, end - 1);
        }
        if (start >= end) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path);
        int delStart = -1;
        int delEnd = -1;
        int skip = 0;
        block9: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (buf.charAt(start + 1) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    if (start < 0 && buf.length() > 2 && buf.charAt(1) == '/' && buf.charAt(2) == '/') break;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if ((delStart = start) < 0 || delStart == 0 && buf.charAt(delStart) == '/') {
                        ++delStart;
                        if (delEnd >= buf.length() || buf.charAt(delEnd) != '/') break;
                        ++delEnd;
                        break;
                    }
                    if (end == buf.length()) {
                        ++delStart;
                    }
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                case 3: {
                    if (buf.charAt(start + 1) != '.' || buf.charAt(start + 2) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    ++skip;
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                default: {
                    if (skip <= 0 || --skip != 0) break;
                    int n = delStart = start >= 0 ? start : 0;
                    if (delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                    ++delStart;
                }
            }
            if (skip <= 0 && delStart >= 0 && delEnd >= delStart) {
                buf.delete(delStart, delEnd);
                delEnd = -1;
                delStart = -1;
                if (skip > 0) {
                    delEnd = end;
                }
            }
            end = start--;
            while (start >= 0 && buf.charAt(start) != '/') {
                --start;
            }
        }
        if (skip > 0) {
            return null;
        }
        if (delEnd >= 0) {
            buf.delete(delStart, delEnd);
        }
        return buf.toString();
    }

    public static String compactPath(String path) {
        int i;
        if (path == null || path.length() == 0) {
            return path;
        }
        int state = 0;
        int end = path.length();
        block8: for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    return path;
                }
                case '/': {
                    if (++state != 2) continue block8;
                    break block8;
                }
                default: {
                    state = 0;
                }
            }
        }
        if (state < 2) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path.length());
        buf.append(path, 0, i);
        block9: while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    buf.append(path, i, end);
                    break block9;
                }
                case '/': {
                    if (state++ != 0) break;
                    buf.append(c);
                    break;
                }
                default: {
                    state = 0;
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }

    public static String newURI(String scheme, String server, int port, String path, String query) {
        StringBuilder builder = URIUtil.newURIBuilder(scheme, server, port);
        builder.append(path);
        if (query != null && query.length() > 0) {
            builder.append('?').append(query);
        }
        return builder.toString();
    }

    public static StringBuilder newURIBuilder(String scheme, String server, int port) {
        StringBuilder builder = new StringBuilder();
        URIUtil.appendSchemeHostPort(builder, scheme, server, port);
        return builder;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        if (server.indexOf(58) >= 0 && server.charAt(0) != '[') {
            url.append(scheme).append("://").append('[').append(server).append(']');
        } else {
            url.append(scheme).append("://").append(server);
        }
        if (port > 0) {
            switch (scheme) {
                case "http": {
                    if (port == 80) break;
                    url.append(':').append(port);
                    break;
                }
                case "https": {
                    if (port == 443) break;
                    url.append(':').append(port);
                    break;
                }
                default: {
                    url.append(':').append(port);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendSchemeHostPort(StringBuffer url, String scheme, String server, int port) {
        StringBuffer stringBuffer = url;
        synchronized (stringBuffer) {
            if (server.indexOf(58) >= 0 && server.charAt(0) != '[') {
                url.append(scheme).append("://").append('[').append(server).append(']');
            } else {
                url.append(scheme).append("://").append(server);
            }
            if (port > 0) {
                switch (scheme) {
                    case "http": {
                        if (port == 80) break;
                        url.append(':').append(port);
                        break;
                    }
                    case "https": {
                        if (port == 443) break;
                        url.append(':').append(port);
                        break;
                    }
                    default: {
                        url.append(':').append(port);
                    }
                }
            }
        }
    }

    public static boolean equalsIgnoreEncodings(String uriA, String uriB) {
        int lenA = uriA.length();
        int lenB = uriB.length();
        int a = 0;
        int b = 0;
        while (a < lenA && b < lenB) {
            int ob;
            int cb;
            int oa;
            int ca;
            if ((ca = (oa = uriA.charAt(a++))) == 37) {
                ca = TypeUtil.convertHexDigit(uriA.charAt(a++)) * 16 + TypeUtil.convertHexDigit(uriA.charAt(a++));
            }
            if ((cb = (ob = uriB.charAt(b++))) == 37) {
                cb = TypeUtil.convertHexDigit(uriB.charAt(b++)) * 16 + TypeUtil.convertHexDigit(uriB.charAt(b++));
            }
            if (ca != cb) {
                return false;
            }
            if (ca != 47 || oa == ob) continue;
            return false;
        }
        return a == lenA && b == lenB;
    }

    static {
        String charset = System.getProperty("org.eclipse.jetty.util.URI.charset");
        __CHARSET = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
    }
}

