/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.NonBlockingThread;

public class SharedBlockingCallback {
    private static final Logger LOG = Log.getLogger(SharedBlockingCallback.class);
    private static Throwable IDLE = new Throwable(){

        @Override
        public String toString() {
            return "IDLE";
        }
    };
    private static Throwable SUCCEEDED = new Throwable(){

        @Override
        public String toString() {
            return "SUCCEEDED";
        }
    };
    final Blocker _blocker;

    public SharedBlockingCallback() {
        this(new Blocker());
    }

    protected SharedBlockingCallback(Blocker blocker) {
        this._blocker = blocker;
    }

    public Blocker acquire() throws IOException {
        this._blocker._lock.lock();
        try {
            while (this._blocker._state != IDLE) {
                this._blocker._idle.await();
            }
            this._blocker._state = null;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(){
                {
                    this.initCause(e);
                }
            };
        }
        finally {
            this._blocker._lock.unlock();
        }
        return this._blocker;
    }

    public static class Blocker
    implements Callback,
    Closeable {
        final ReentrantLock _lock = new ReentrantLock();
        final Condition _idle = this._lock.newCondition();
        final Condition _complete = this._lock.newCondition();
        Throwable _state = SharedBlockingCallback.access$000();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void succeeded() {
            this._lock.lock();
            try {
                if (this._state == null) {
                    this._state = SUCCEEDED;
                    this._complete.signalAll();
                } else if (this._state == IDLE) {
                    throw new IllegalStateException("IDLE");
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable cause) {
            this._lock.lock();
            try {
                if (this._state == null) {
                    this._state = cause;
                    this._complete.signalAll();
                } else if (this._state == IDLE) {
                    throw new IllegalStateException("IDLE");
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        public void block() throws IOException {
            if (NonBlockingThread.isNonBlockingThread()) {
                LOG.warn("Blocking a NonBlockingThread: ", new Throwable());
            }
            this._lock.lock();
            try {
                while (this._state == null) {
                    this._complete.await();
                }
                if (this._state == SUCCEEDED) {
                    return;
                }
                try {
                    if (this._state == IDLE) {
                        throw new IllegalStateException("IDLE");
                    }
                    if (this._state instanceof IOException) {
                        throw (IOException)this._state;
                    }
                    if (this._state instanceof CancellationException) {
                        throw (CancellationException)this._state;
                    }
                    if (this._state instanceof RuntimeException) {
                        throw (RuntimeException)this._state;
                    }
                    if (this._state instanceof Error) {
                        throw (Error)this._state;
                    }
                    throw new IOException(this._state);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(){
                        {
                            this.initCause(e);
                        }
                    };
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this._lock.lock();
            try {
                if (this._state == IDLE) {
                    throw new IllegalStateException("IDLE");
                }
                if (this._state == null) {
                    LOG.warn(new Throwable());
                }
            }
            finally {
                this._state = IDLE;
                this._idle.signalAll();
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            this._lock.lock();
            try {
                String string = String.format("%s@%x{%s}", SharedBlockingCallback.class.getSimpleName(), this.hashCode(), this._state);
                return string;
            }
            finally {
                this._lock.unlock();
            }
        }
    }
}

