/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncHttpConnection
extends HttpConnection {
    private static final int NO_PROGRESS_INFO = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_INFO", 100);
    private static final int NO_PROGRESS_CLOSE = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_CLOSE", 200);
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);
    private int _total_no_progress;

    public AsyncHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection handle() throws IOException {
        AsyncHttpConnection connection = this;
        boolean some_progress = false;
        boolean progress = true;
        try {
            AsyncHttpConnection.setCurrentConnection(this);
            boolean more_in_buffer = false;
            while (this._endp.isOpen() && (more_in_buffer || progress) && connection == this) {
                Connection switched;
                Object var7_6;
                progress = false;
                try {
                    block40: {
                        try {
                            if (this._request._async.isAsync() && !this._request._async.isComplete()) {
                                this.handleRequest();
                            } else if (!this._parser.isComplete() && this._parser.parseAvailable() > 0) {
                                progress = true;
                            }
                            if (this._generator.isCommitted() && !this._generator.isComplete() && this._generator.flushBuffer() > 0L) {
                                progress = true;
                            }
                            if (this._endp.isBufferingOutput()) {
                                this._endp.flush();
                            }
                            if (progress || some_progress || !this._endp.isInputShutdown() && !this._endp.isOutputShutdown()) break block40;
                            this._endp.close();
                        }
                        catch (HttpException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("uri=" + this._uri, new Object[0]);
                                LOG.debug("fields=" + this._requestFields, new Object[0]);
                                LOG.debug((Throwable)e);
                            }
                            this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                            this._parser.reset();
                            this._endp.close();
                            var7_6 = null;
                            if (this._endp.isInputShutdown() && (this._parser.isIdle() || this._parser.isComplete())) {
                                LOG.debug("complete half close {}", new Object[]{this});
                                more_in_buffer = false;
                                this._endp.close();
                                this.reset(true);
                            } else if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                                if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                    this._parser.reset();
                                    this._generator.reset(true);
                                    connection = switched;
                                }
                                progress = true;
                                this.reset(false);
                                more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            } else if (this._request.isAsyncStarted()) {
                                LOG.debug("suspended {}", new Object[]{this});
                                more_in_buffer = false;
                                progress = false;
                            } else {
                                more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            }
                            some_progress |= progress | ((SelectChannelEndPoint)this._endp).isProgressing();
                            continue;
                        }
                    }
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    if (this._endp.isInputShutdown() && (this._parser.isIdle() || this._parser.isComplete())) {
                        LOG.debug("complete half close {}", new Object[]{this});
                        more_in_buffer = false;
                        this._endp.close();
                        this.reset(true);
                    } else if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                        if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                            this._parser.reset();
                            this._generator.reset(true);
                            connection = switched;
                        }
                        progress = true;
                        this.reset(false);
                        more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    } else if (this._request.isAsyncStarted()) {
                        LOG.debug("suspended {}", new Object[]{this});
                        more_in_buffer = false;
                        progress = false;
                    } else {
                        more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    }
                    some_progress |= progress | ((SelectChannelEndPoint)this._endp).isProgressing();
                    throw throwable;
                }
                if (this._endp.isInputShutdown() && (this._parser.isIdle() || this._parser.isComplete())) {
                    LOG.debug("complete half close {}", new Object[]{this});
                    more_in_buffer = false;
                    this._endp.close();
                    this.reset(true);
                } else if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                    if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                        this._parser.reset();
                        this._generator.reset(true);
                        connection = switched;
                    }
                    progress = true;
                    this.reset(false);
                    more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                } else if (this._request.isAsyncStarted()) {
                    LOG.debug("suspended {}", new Object[]{this});
                    more_in_buffer = false;
                    progress = false;
                } else {
                    more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                }
                some_progress |= progress | ((SelectChannelEndPoint)this._endp).isProgressing();
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            AsyncHttpConnection.setCurrentConnection(null);
            this._parser.returnBuffers();
            this._generator.returnBuffers();
            if (this._generator.isCommitted() && !this._generator.isComplete() && this._endp.isOpen() && !this._endp.isOutputShutdown()) {
                ((AsyncEndPoint)this._endp).scheduleWrite();
            }
            if (some_progress) {
                this._total_no_progress = 0;
                throw throwable;
            }
            int totalNoProgress = ++this._total_no_progress;
            if (NO_PROGRESS_INFO > 0 && totalNoProgress == NO_PROGRESS_INFO && (NO_PROGRESS_CLOSE <= 0 || totalNoProgress < NO_PROGRESS_CLOSE)) {
                LOG.info("EndPoint making no progress: {} {}", new Object[]{totalNoProgress, this._endp});
            }
            if (NO_PROGRESS_CLOSE <= 0) throw throwable;
            if (totalNoProgress != NO_PROGRESS_CLOSE) throw throwable;
            LOG.warn("Closing EndPoint making no progress: {} {}", new Object[]{totalNoProgress, this._endp});
            if (!(this._endp instanceof SelectChannelEndPoint)) throw throwable;
            System.err.println(((SelectChannelEndPoint)this._endp).getSelectManager().dump());
            ((SelectChannelEndPoint)this._endp).getChannel().close();
            throw throwable;
        }
        AsyncHttpConnection.setCurrentConnection(null);
        this._parser.returnBuffers();
        this._generator.returnBuffers();
        if (this._generator.isCommitted() && !this._generator.isComplete() && this._endp.isOpen() && !this._endp.isOutputShutdown()) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
        if (some_progress) {
            this._total_no_progress = 0;
            return connection;
        }
        int totalNoProgress = ++this._total_no_progress;
        if (NO_PROGRESS_INFO > 0 && totalNoProgress == NO_PROGRESS_INFO && (NO_PROGRESS_CLOSE <= 0 || totalNoProgress < NO_PROGRESS_CLOSE)) {
            LOG.info("EndPoint making no progress: {} {}", new Object[]{totalNoProgress, this._endp});
        }
        if (NO_PROGRESS_CLOSE <= 0) return connection;
        if (totalNoProgress != NO_PROGRESS_CLOSE) return connection;
        LOG.warn("Closing EndPoint making no progress: {} {}", new Object[]{totalNoProgress, this._endp});
        if (!(this._endp instanceof SelectChannelEndPoint)) return connection;
        System.err.println(((SelectChannelEndPoint)this._endp).getSelectManager().dump());
        ((SelectChannelEndPoint)this._endp).getChannel().close();
        return connection;
    }
}

