/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import org.eclipse.jetty.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;

public class MavenWebInfConfiguration
extends WebInfConfiguration {
    private static final Logger LOG = Log.getLogger(MavenWebInfConfiguration.class);

    public MavenWebInfConfiguration() {
        this.hide(new String[]{"org.apache.maven.", "org.codehaus.plexus.", "javax.enterprise.", "javax.decorator."});
    }

    public Class<? extends Configuration> replaces() {
        return WebInfConfiguration.class;
    }

    public void configure(WebAppContext context) throws Exception {
        MavenWebAppContext jwac = (MavenWebAppContext)context;
        if (jwac.getClassPathFiles() != null && context.getClassLoader() instanceof WebAppClassLoader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up classpath ...", new Object[0]);
            }
            WebAppClassLoader loader = (WebAppClassLoader)context.getClassLoader();
            for (File classpath : jwac.getClassPathFiles()) {
                loader.addClassPath(classpath.getCanonicalPath());
            }
        }
        super.configure(context);
    }
}

