/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.StringUtil;

public enum HttpHeader {
    CONNECTION("Connection"),
    CACHE_CONTROL("Cache-Control"),
    DATE("Date"),
    PRAGMA("Pragma"),
    PROXY_CONNECTION("Proxy-Connection"),
    TRAILER("Trailer"),
    TRANSFER_ENCODING("Transfer-Encoding"),
    UPGRADE("Upgrade"),
    VIA("Via"),
    WARNING("Warning"),
    NEGOTIATE("Negotiate"),
    ALLOW("Allow"),
    CONTENT_ENCODING("Content-Encoding"),
    CONTENT_LANGUAGE("Content-Language"),
    CONTENT_LENGTH("Content-Length"),
    CONTENT_LOCATION("Content-Location"),
    CONTENT_MD5("Content-MD5"),
    CONTENT_RANGE("Content-Range"),
    CONTENT_TYPE("Content-Type"),
    EXPIRES("Expires"),
    LAST_MODIFIED("Last-Modified"),
    ACCEPT("Accept"),
    ACCEPT_CHARSET("Accept-Charset"),
    ACCEPT_ENCODING("Accept-Encoding"),
    ACCEPT_LANGUAGE("Accept-Language"),
    AUTHORIZATION("Authorization"),
    EXPECT("Expect"),
    FORWARDED("Forwarded"),
    FROM("From"),
    HOST("Host"),
    IF_MATCH("If-Match"),
    IF_MODIFIED_SINCE("If-Modified-Since"),
    IF_NONE_MATCH("If-None-Match"),
    IF_RANGE("If-Range"),
    IF_UNMODIFIED_SINCE("If-Unmodified-Since"),
    KEEP_ALIVE("Keep-Alive"),
    MAX_FORWARDS("Max-Forwards"),
    PROXY_AUTHORIZATION("Proxy-Authorization"),
    RANGE("Range"),
    REQUEST_RANGE("Request-Range"),
    REFERER("Referer"),
    TE("TE"),
    USER_AGENT("User-Agent"),
    X_FORWARDED_FOR("X-Forwarded-For"),
    X_FORWARDED_PROTO("X-Forwarded-Proto"),
    X_FORWARDED_SERVER("X-Forwarded-Server"),
    X_FORWARDED_HOST("X-Forwarded-Host"),
    ACCEPT_RANGES("Accept-Ranges"),
    AGE("Age"),
    ETAG("ETag"),
    LOCATION("Location"),
    PROXY_AUTHENTICATE("Proxy-Authenticate"),
    RETRY_AFTER("Retry-After"),
    SERVER("Server"),
    SERVLET_ENGINE("Servlet-Engine"),
    VARY("Vary"),
    WWW_AUTHENTICATE("WWW-Authenticate"),
    COOKIE("Cookie"),
    SET_COOKIE("Set-Cookie"),
    SET_COOKIE2("Set-Cookie2"),
    MIME_VERSION("MIME-Version"),
    IDENTITY("identity"),
    UNKNOWN("::UNKNOWN::");

    public static final StringMap<HttpHeader> CACHE;
    private static final HttpHeader[] __hashed;
    private static final int __maxHashed;
    private final String _string;
    private final byte[] _bytes;
    private final byte[] _bytesColonSpace;
    private final ByteBuffer _buffer;

    public static HttpHeader lookAheadGet(byte[] bytes, int position, int limit) {
        HttpHeader header;
        int h = 0;
        int b = 0;
        limit = Math.min(position + __maxHashed, limit);
        for (int i = position; i < limit && (b = bytes[i]) != 58 && b != 32; ++i) {
            h = 31 * h + (b >= 97 ? b - 97 + 65 : b);
        }
        if (b != 58 && b != 32) {
            return null;
        }
        int hash = h % __hashed.length;
        if (hash < 0) {
            hash = -hash;
        }
        if ((header = __hashed[hash]) != null) {
            String s = header.asString();
            int i = s.length();
            while (i-- > 0) {
                b = bytes[position + i];
                int c = s.charAt(i);
                if (c == b || Character.toUpperCase((char)c) == (b >= 97 ? b - 97 + 65 : b)) continue;
                return null;
            }
        }
        return header;
    }

    private HttpHeader(String s) {
        this._string = s;
        this._bytes = StringUtil.getBytes((String)s);
        this._bytesColonSpace = StringUtil.getBytes((String)(s + ": "));
        this._buffer = ByteBuffer.wrap(this._bytes);
    }

    public ByteBuffer toBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public byte[] getBytesColonSpace() {
        return this._bytesColonSpace;
    }

    public boolean is(String s) {
        return this._string.equalsIgnoreCase(s);
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    static {
        CACHE = new StringMap(true);
        for (HttpHeader header : HttpHeader.values()) {
            if (header == UNKNOWN) continue;
            CACHE.put(header.toString(), (Object)header);
        }
        __hashed = new HttpHeader[4096];
        int max = 0;
        HashMap<Integer, HttpHeader> hashes = new HashMap<Integer, HttpHeader>();
        for (HttpHeader header : HttpHeader.values()) {
            String s = header.asString();
            max = Math.max(max, s.length());
            int h = 0;
            for (int n : s.toCharArray()) {
                h = 31 * h + (n >= 97 ? n - 97 + 65 : n);
            }
            int hash = h % __hashed.length;
            if (hash < 0) {
                hash = -hash;
            }
            if (hashes.containsKey(hash)) {
                System.err.println("Duplicate hash " + (Object)((Object)header) + " " + hashes.get(hash));
                System.exit(1);
            }
            hashes.put(hash, header);
            HttpHeader.__hashed[hash] = header;
        }
        __maxHashed = max;
    }
}

