/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.UnsupportedEncodingException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.Utf8StringBuffer;

public class EncodedHttpURI
extends HttpURI {
    private final String _encoding;

    public EncodedHttpURI(String encoding) {
        this._encoding = encoding;
    }

    public String getScheme() {
        if (this._scheme == this._authority) {
            return null;
        }
        int l = this._authority - this._scheme;
        if (l == 5 && this._raw[this._scheme] == 104 && this._raw[this._scheme + 1] == 116 && this._raw[this._scheme + 2] == 116 && this._raw[this._scheme + 3] == 112) {
            return "http";
        }
        if (l == 6 && this._raw[this._scheme] == 104 && this._raw[this._scheme + 1] == 116 && this._raw[this._scheme + 2] == 116 && this._raw[this._scheme + 3] == 112 && this._raw[this._scheme + 4] == 115) {
            return "https";
        }
        return StringUtil.toString((byte[])this._raw, (int)this._scheme, (int)(this._authority - this._scheme - 1), (String)this._encoding);
    }

    public String getAuthority() {
        if (this._authority == this._path) {
            return null;
        }
        return StringUtil.toString((byte[])this._raw, (int)this._authority, (int)(this._path - this._authority), (String)this._encoding);
    }

    public String getHost() {
        if (this._host == this._port) {
            return null;
        }
        return StringUtil.toString((byte[])this._raw, (int)this._host, (int)(this._port - this._host), (String)this._encoding);
    }

    public int getPort() {
        if (this._port == this._path) {
            return -1;
        }
        return TypeUtil.parseInt((byte[])this._raw, (int)(this._port + 1), (int)(this._path - this._port - 1), (int)10);
    }

    public String getPath() {
        if (this._path == this._param) {
            return null;
        }
        return StringUtil.toString((byte[])this._raw, (int)this._path, (int)(this._param - this._path), (String)this._encoding);
    }

    public String getDecodedPath() {
        if (this._path == this._param) {
            return null;
        }
        return URIUtil.decodePath((byte[])this._raw, (int)this._path, (int)(this._param - this._path));
    }

    public String getPathAndParam() {
        if (this._path == this._query) {
            return null;
        }
        return StringUtil.toString((byte[])this._raw, (int)this._path, (int)(this._query - this._path), (String)this._encoding);
    }

    public String getCompletePath() {
        if (this._path == this._end) {
            return null;
        }
        return StringUtil.toString((byte[])this._raw, (int)this._path, (int)(this._end - this._path), (String)this._encoding);
    }

    public String getParam() {
        if (this._param == this._query) {
            return null;
        }
        return StringUtil.toString((byte[])this._raw, (int)(this._param + 1), (int)(this._query - this._param - 1), (String)this._encoding);
    }

    public String getQuery() {
        if (this._query == this._fragment) {
            return null;
        }
        return StringUtil.toString((byte[])this._raw, (int)(this._query + 1), (int)(this._fragment - this._query - 1), (String)this._encoding);
    }

    public boolean hasQuery() {
        return this._fragment > this._query;
    }

    public String getFragment() {
        if (this._fragment == this._end) {
            return null;
        }
        return StringUtil.toString((byte[])this._raw, (int)(this._fragment + 1), (int)(this._end - this._fragment - 1), (String)this._encoding);
    }

    public void decodeQueryTo(MultiMap parameters) {
        if (this._query == this._fragment) {
            return;
        }
        UrlEncoded.decodeTo((String)StringUtil.toString((byte[])this._raw, (int)(this._query + 1), (int)(this._fragment - this._query - 1), (String)this._encoding), (MultiMap)parameters, (String)this._encoding);
    }

    public void decodeQueryTo(MultiMap parameters, String encoding) throws UnsupportedEncodingException {
        if (this._query == this._fragment) {
            return;
        }
        if (encoding == null) {
            encoding = this._encoding;
        }
        UrlEncoded.decodeTo((String)StringUtil.toString((byte[])this._raw, (int)(this._query + 1), (int)(this._fragment - this._query - 1), (String)encoding), (MultiMap)parameters, (String)encoding);
    }

    public String toString() {
        if (this._rawString == null) {
            this._rawString = StringUtil.toString((byte[])this._raw, (int)this._scheme, (int)(this._end - this._scheme), (String)this._encoding);
        }
        return this._rawString;
    }

    public void writeTo(Utf8StringBuffer buf) {
        buf.getStringBuffer().append(this.toString());
    }
}

