/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import uk.co.spudsoft.birt.emitters.excel.ExcelEmitter;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerXUtils;

public class XlsxEmitter
extends ExcelEmitter {
    public XlsxEmitter() {
        super(StyleManagerXUtils.getFactory());
        this.log.debug("Constructed XlsxEmitter");
    }

    @Override
    public String getOutputFormat() {
        return "xlsx";
    }

    @Override
    protected Workbook createWorkbook() {
        return new XSSFWorkbook();
    }

    @Override
    protected Workbook openWorkbook(File templateFile) throws IOException {
        FileInputStream stream = new FileInputStream(templateFile);
        try {
            XSSFWorkbook xSSFWorkbook = new XSSFWorkbook((InputStream)stream);
            return xSSFWorkbook;
        }
        finally {
            ((InputStream)stream).close();
        }
    }
}

