/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.extension.IChoiceDefinition;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionChoice;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructureDefn;

public class ExtensionModelPropertyDefn
extends ElementPropertyDefn {
    private IPropertyDefinition extProperty = null;
    private IMessages messages = null;

    public ExtensionModelPropertyDefn(IPropertyDefinition extPropertyDefn, IMessages messages) {
        this.extProperty = extPropertyDefn;
        assert (this.extProperty != null);
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        this.type = dd.getPropertyType(this.extProperty.getType());
        this.name = this.extProperty.getName();
        this.defaultValue = this.extProperty.getDefaultValue();
        this.messages = messages;
        assert (this.type != null);
        this.buildTrimOption(this.type.getTypeCode());
    }

    public int getValueType() {
        return 3;
    }

    public boolean canInherit() {
        return false;
    }

    public String getGroupName() {
        if (this.extProperty.getGroupNameID() != null && this.messages != null) {
            return this.messages.getMessage(this.extProperty.getGroupNameID(), ThreadResources.getLocale());
        }
        return null;
    }

    public String getGroupNameKey() {
        return this.extProperty.getGroupNameID();
    }

    public IMethodInfo getMethodInfo() {
        if (this.type.getTypeCode() == 18) {
            return this.extProperty.getMethodInfo();
        }
        return null;
    }

    public boolean isStyleProperty() {
        return false;
    }

    void setCanInherit(boolean flag) {
        assert (false);
    }

    void setGroupNameKey(String id) {
        assert (false);
    }

    public IChoiceSet getAllowedChoices() {
        return this.getChoices();
    }

    public IChoiceSet getChoices() {
        List<IChoiceDefinition> choices = this.extProperty.getChoices();
        if (choices == null) {
            return null;
        }
        if (choices.size() == 0) {
            return null;
        }
        IChoice[] choiceArray = new Choice[choices.size()];
        Iterator iter = choices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IChoiceDefinition choice = (IChoiceDefinition)iter.next();
            ExtensionChoice extChoice = new ExtensionChoice(choice, this.messages);
            choiceArray[i] = extChoice;
            ++i;
        }
        assert (i == choices.size());
        ChoiceSet set = new ChoiceSet();
        set.setChoices(choiceArray);
        this.details = set;
        return set;
    }

    public Object getDefault() {
        return this.extProperty.getDefaultValue();
    }

    public String getDisplayName() {
        String displayName;
        if (this.extProperty.getDisplayNameID() != null && this.messages != null && !StringUtil.isBlank(displayName = this.messages.getMessage(this.extProperty.getDisplayNameID(), ThreadResources.getLocale()))) {
            return displayName;
        }
        return this.extProperty.getName();
    }

    public String getDisplayNameID() {
        return this.extProperty.getDisplayNameID();
    }

    public String getName() {
        return this.extProperty.getName();
    }

    public IStructureDefn getStructDefn() {
        if (this.details instanceof StructureDefn) {
            return (StructureDefn)this.details;
        }
        return null;
    }

    public IElementDefn getTargetElementType() {
        return null;
    }

    public PropertyType getType() {
        int typeCode = this.extProperty.getType();
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        return dd.getPropertyType(typeCode);
    }

    public int getTypeCode() {
        PropertyType type = this.getType();
        assert (type != null);
        return type.getTypeCode();
    }

    public boolean isIntrinsic() {
        return false;
    }

    public boolean isList() {
        return this.extProperty.isList();
    }

    void setAllowedChoices(ChoiceSet allowedChoices) {
        assert (false);
    }

    protected void setDefault(Object value) {
        assert (false);
    }

    public void setDisplayNameID(String id) {
        assert (false);
    }

    void setIntrinsic(boolean flag) {
        assert (false);
    }

    protected void setIsList(boolean isList) {
        assert (false);
    }

    public void setName(String theName) {
        assert (false);
    }

    public void setType(PropertyType typeDefn) {
        assert (false);
    }

    public boolean isReadOnly() {
        return this.extProperty.isReadOnly();
    }

    public boolean isVisible() {
        return this.extProperty.isVisible();
    }
}

