/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.IReportItemVisitor;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextItemDesign
extends ReportItemDesign {
    public static final String AUTO_TEXT = "auto";
    public static final String PLAIN_TEXT = "plain";
    public static final String HTML_TEXT = "html";
    public static final String RTF_TEXT = "rtf";
    protected String textType;
    protected String textKey;
    protected String text;
    protected boolean hasExpression;
    protected HashMap<String, Expression> exprs = null;

    public HashMap<String, Expression> getExpressions() {
        if (!this.hasExpression()) {
            return null;
        }
        if (this.text == null) {
            return null;
        }
        if (this.exprs != null) {
            return this.exprs;
        }
        this.exprs = TextItemDesign.extractExpression(this.text, this.textType);
        return this.exprs;
    }

    public static HashMap<String, Expression> extractExpression(String textContent, String textType) {
        HashMap<String, Expression> expressions = new HashMap<String, Expression>();
        if (HTML_TEXT.equals(textType) || AUTO_TEXT.equals(textType) && TextItemDesign.startsWithIgnoreCase(textContent, "<html>")) {
            TextTemplate template = null;
            try {
                template = new TemplateParser().parse(textContent);
            }
            catch (Throwable throwable) {}
            if (template != null && template.getNodes() != null) {
                for (Object obj : template.getNodes()) {
                    if (obj instanceof TextTemplate.ValueNode) {
                        TextTemplate.ValueNode valueNode = (TextTemplate.ValueNode)obj;
                        TextItemDesign.addExpression(expressions, valueNode.getValue());
                        TextItemDesign.addExpression(expressions, valueNode.getFormatExpression());
                        continue;
                    }
                    if (!(obj instanceof TextTemplate.ImageNode)) continue;
                    TextItemDesign.addExpression(expressions, ((TextTemplate.ImageNode)obj).getExpr());
                }
            }
        }
        return expressions;
    }

    private static void addExpression(Map<String, Expression> expressions, String expression) {
        if (expression != null && (expression = expression.trim()).length() > 0) {
            expressions.put(expression, Expression.newScript(expression));
        }
    }

    public static boolean startsWithIgnoreCase(String original, String pattern) {
        int length = pattern.length();
        if (original == null || original.length() < length) {
            return false;
        }
        return original.substring(0, length).equalsIgnoreCase(pattern);
    }

    public void setText(String textKey, String text) {
        this.textKey = textKey;
        this.text = text;
    }

    public String getTextKey() {
        return this.textKey;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public Object accept(IReportItemVisitor visitor, Object value) {
        return visitor.visitTextItem(this, value);
    }

    public String getTextType() {
        return this.textType;
    }

    public void setTextType(String textType) {
        this.textType = textType;
    }

    public boolean hasExpression() {
        return this.hasExpression;
    }

    public void setHasExpression(boolean hasExpression) {
        this.hasExpression = hasExpression;
    }
}

