/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.excel.BlankData;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.DataCache;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleBuilder;
import org.eclipse.birt.report.engine.emitter.excel.StyleEngine;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.AxisProcessor;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsCell;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;
import org.eclipse.birt.report.model.api.util.ColorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page {
    public static final float DEFAULT_ROW_HEIGHT = 15.0f;
    protected static Logger logger = Logger.getLogger(Page.class.getName());
    protected AxisProcessor axis;
    protected DataCache currentCache;
    protected List<DataCache> caches = new ArrayList<DataCache>();
    private int maxCol;
    private StyleEngine styleEngine;
    private boolean outputInMasterPage = false;
    private String header;
    private String footer;
    private String orientation;
    private List<BookmarkDef> bookmarks = new ArrayList<BookmarkDef>();
    private String sheetName;
    private XlsContainer pageContainer;
    private int pageWidth;
    private int lastInRangeCoordinateIndex = -1;

    public Page(int contentWidth, StyleEngine styleEngine, int maxCol, String sheetName, XlsContainer pageContainer) {
        this.axis = new AxisProcessor();
        this.styleEngine = styleEngine;
        this.pageWidth = contentWidth;
        this.maxCol = maxCol;
        this.sheetName = sheetName;
        this.pageContainer = pageContainer;
    }

    public void addPageCoordinate() {
        this.axis.addCoordinate(this.pageWidth);
    }

    public void startPage(IPageContent pageContent) {
        this.orientation = this.capitalize(pageContent.getOrientation());
        if (this.needOutputInMasterPage(pageContent.getPageHeader()) && this.needOutputInMasterPage(pageContent.getPageFooter())) {
            this.outputInMasterPage = true;
            this.header = this.formatHeaderFooter(pageContent.getPageHeader());
            this.footer = this.formatHeaderFooter(pageContent.getPageFooter());
        }
    }

    public void startPage(Page page) {
        this.orientation = page.orientation;
        this.outputInMasterPage = page.outputInMasterPage;
        this.header = page.header;
        this.footer = page.footer;
    }

    public void setOutputInMasterPage(boolean outputInMasterPage) {
        this.outputInMasterPage = outputInMasterPage;
    }

    public boolean isOutputInMasterPage() {
        return this.outputInMasterPage;
    }

    public void initalize() {
        this.currentCache = this.createDataCache(0, this.maxCol);
        this.caches.add(this.currentCache);
    }

    protected DataCache createDataCache(int offset, int maxColumn) {
        return new DataCache(offset, maxColumn);
    }

    public void splitColumns(int startCoordinate, int endCoordinate, int[] columnStartCoordinates, boolean autoExtend) {
        if (this.axis.getColumnsCount() == 1) {
            int[] nArray = columnStartCoordinates;
            int n = columnStartCoordinates.length;
            int n2 = 0;
            while (n2 < n) {
                int columnCoordinate = nArray[n2];
                this.axis.addCoordinate(columnCoordinate);
                ++n2;
            }
            this.currentCache.insertColumns(columnStartCoordinates.length - 1);
            return;
        }
        this.lastInRangeCoordinateIndex = -1;
        int[] scale = this.axis.getColumnCoordinatesInRange(startCoordinate, endCoordinate);
        int i = 0;
        while (i < scale.length - 1) {
            int startPosition = scale[i];
            int endPosition = scale[i + 1];
            int[] range = this.inRange(startPosition, endPosition, columnStartCoordinates);
            if (range.length > 0) {
                int pos = this.axis.getColumnIndexByCoordinate(startPosition);
                this.currentCache.insertColumns(pos, range.length);
                int j = 0;
                while (j < range.length) {
                    this.axis.addCoordinate(range[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (autoExtend) {
            int currentColumnCount = columnStartCoordinates.length;
            if (this.lastInRangeCoordinateIndex < currentColumnCount - 1 && AxisProcessor.round(columnStartCoordinates[this.lastInRangeCoordinateIndex + 1]) == scale[scale.length - 1]) {
                ++this.lastInRangeCoordinateIndex;
            }
            int i2 = this.lastInRangeCoordinateIndex + 1;
            while (i2 < currentColumnCount) {
                this.axis.addCoordinate(columnStartCoordinates[i2]);
                ++i2;
            }
            int newColumnCount = currentColumnCount - (this.lastInRangeCoordinateIndex + 1);
            this.currentCache.insertColumns(newColumnCount);
        }
    }

    public String formatHeaderFooter(IContent content) {
        StringBuffer headfoot = new StringBuffer();
        if (content != null) {
            Collection list = content.getChildren();
            for (Object child : list) {
                if (child instanceof ITableContent) {
                    headfoot.append(this.getTableValue((ITableContent)child));
                    continue;
                }
                this.processText(headfoot, child);
            }
            return headfoot.toString();
        }
        return null;
    }

    private void processText(StringBuffer buffer, Object child) {
        if (child instanceof IAutoTextContent) {
            this.processTextStyle(buffer, ((IAutoTextContent)child).getComputedStyle());
            buffer.append(this.getAutoText((IAutoTextContent)child));
        } else if (child instanceof ITextContent) {
            this.processTextStyle(buffer, ((ITextContent)child).getComputedStyle());
            buffer.append(((ITextContent)child).getText());
        } else if (child instanceof IForeignContent) {
            this.processTextStyle(buffer, ((IForeignContent)child).getComputedStyle());
            buffer.append(((IForeignContent)child).getRawValue());
        }
    }

    private void processTextStyle(StringBuffer buffer, IStyle style) {
        int value;
        String color;
        String lineTrough;
        this.outputStyleInQuote(style.getFontFamily(), style.getFontWeight(), style.getFontStyle(), buffer);
        String underLine = style.getTextUnderline();
        if (underLine != null && underLine.equalsIgnoreCase("underline")) {
            buffer.append("&U");
        }
        if ((lineTrough = style.getTextLineThrough()) != null && "line-through".equalsIgnoreCase(lineTrough)) {
            buffer.append("&S");
        }
        if (style.getProperty(44) != null) {
            buffer.append("&");
            buffer.append((int)StyleBuilder.convertFontSize(style.getProperty(44)));
        }
        if ((color = style.getColor()) != null && (value = ColorUtil.parseColor(color)) >= 0) {
            buffer.append("&K");
            buffer.append(Integer.toHexString(0x1000000 | value).substring(1));
        }
    }

    private void outputStyleInQuote(String fontFamily, String bold, String italic, StringBuffer buffer) {
        if (this.needOutputInQuote(fontFamily, bold, italic)) {
            buffer.append("&\"");
            if (fontFamily != null) {
                buffer.append(ExcelUtil.getValue(fontFamily));
            }
            if (bold != null && "bold".equalsIgnoreCase(bold)) {
                if (fontFamily != null) {
                    buffer.append(",");
                }
                buffer.append("Bold");
            }
            if (italic != null && "italic".equalsIgnoreCase(italic)) {
                if (bold != null && "bold".equalsIgnoreCase(bold)) {
                    buffer.append(" ");
                } else if (fontFamily != null) {
                    buffer.append(",");
                }
                buffer.append("Italic");
            }
            buffer.append("\"");
        }
    }

    private boolean needOutputInQuote(String fontFamily, String bold, String italic) {
        return fontFamily != null || bold != null && "bold".equalsIgnoreCase(bold) || italic != null && "italic".equalsIgnoreCase(italic);
    }

    public String getTableValue(ITableContent table) {
        StringBuffer tableValue = new StringBuffer();
        Collection list = table.getChildren();
        for (Object child : list) {
            tableValue.append(this.getRowValue((IRowContent)child));
        }
        return tableValue.toString();
    }

    public String getRowValue(IRowContent row) {
        StringBuffer rowValue = new StringBuffer();
        Collection list = row.getChildren();
        Iterator iter = list.iterator();
        int currentCellCount = 0;
        while (iter.hasNext()) {
            Object child = iter.next();
            switch (++currentCellCount) {
                case 1: {
                    rowValue.append("&L");
                    break;
                }
                case 2: {
                    rowValue.append("&C");
                    break;
                }
                case 3: {
                    rowValue.append("&R");
                    break;
                }
            }
            rowValue.append(this.getCellValue((ICellContent)child));
        }
        return rowValue.toString();
    }

    public String getCellValue(ICellContent cell) {
        StringBuffer cellValue = new StringBuffer();
        Collection list = cell.getChildren();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.processText(cellValue, iter.next());
        }
        return cellValue.toString();
    }

    public void createNewCache() {
        this.currentCache = new DataCache(this.currentCache);
    }

    private String getAutoText(IAutoTextContent autoText) {
        String result = null;
        int type = autoText.getType();
        result = type == 1 ? "&P" : (type == 0 ? "&N" : autoText.getText());
        return result;
    }

    private String capitalize(String orientation) {
        if (orientation != null) {
            if (orientation.equalsIgnoreCase("landscape")) {
                return "Landscape";
            }
            if (orientation.equalsIgnoreCase("portrait")) {
                return "Portrait";
            }
        }
        return null;
    }

    private int[] inRange(int start, int end, int[] data) {
        int[] range = new int[data.length];
        int count = 0;
        int i = 0;
        while (i < range.length) {
            int value = AxisProcessor.round(data[i]);
            if (value > start && value < end) {
                range[count++] = value;
                this.lastInRangeCoordinateIndex = i;
            }
            ++i;
        }
        int[] result = new int[count];
        System.arraycopy(range, 0, result, 0, count);
        return result;
    }

    public void addData(SheetData data, XlsContainer container) {
        container.setEmpty(false);
        int col = this.axis.getColumnIndexByCoordinate(data.getStartX());
        int span = this.axis.getColumnIndexByCoordinate(data.getEndX()) - col;
        this.updataRowIndex(data, container);
        this.addDatatoCache(col, data);
        int i = col + 1;
        while (i < col + span) {
            BlankData blankData = new BlankData(data);
            blankData.setType(BlankData.Type.HORIZONTAL);
            this.addDatatoCache(i, blankData);
            ++i;
        }
        if (data.getDataType() == 5) {
            this.addEmptyData(data, container);
        }
        while (container != null) {
            if (container instanceof XlsCell) {
                XlsCell cell = (XlsCell)container;
                data.setRowSpanInDesign(cell.getRowSpan() - 1);
                break;
            }
            container = container.getParent();
        }
    }

    public boolean isValid(SheetData data) {
        if (data.getStartX() == data.getEndX()) {
            return false;
        }
        int col = this.axis.getColumnIndexByCoordinate(data.getStartX());
        return col != -1 && col < this.currentCache.getColumnCount();
    }

    public void addEmptyData(SheetData data, XlsContainer container) {
        Data empty;
        int num;
        int column;
        StyleEntry style;
        int parentStartCoordinate = container.getSizeInfo().getStartCoordinate();
        int parentEndCoordinate = container.getSizeInfo().getEndCoordinate();
        int childStartCoordinate = data.getStartX();
        int childEndCoordinate = data.getEndX();
        if (childEndCoordinate < parentEndCoordinate) {
            style = container.getStyle();
            this.removeLeftBorder(style);
            column = this.axis.getColumnIndexByCoordinate(childEndCoordinate);
            num = this.axis.getColumnIndexByCoordinate(parentEndCoordinate) - column - 1;
            empty = this.createEmptyData(style);
            empty.setStartX(childEndCoordinate);
            empty.setEndX(parentEndCoordinate);
            empty.setRowIndex(data.getRowIndex());
            this.addDatatoCache(column, empty);
            this.addBlankData(column, num, empty);
        }
        if (childStartCoordinate > parentStartCoordinate) {
            style = container.getStyle();
            this.removeRightBorder(style);
            column = this.axis.getColumnIndexByCoordinate(childStartCoordinate);
            num = column - this.axis.getColumnIndexByCoordinate(parentStartCoordinate) - 1;
            empty = this.createEmptyData(style);
            empty.setStartX(childStartCoordinate);
            empty.setEndX(parentEndCoordinate);
            empty.setRowIndex(data.getRowIndex());
            this.addDatatoCache(column, empty);
            this.addBlankData(column - num - 1, num, empty);
        }
    }

    public boolean needOutputInMasterPage(IContent headerFooter) {
        if (headerFooter != null) {
            Collection list = headerFooter.getChildren();
            for (Object child : list) {
                if (child instanceof ITableContent) {
                    int columncount = ((ITableContent)child).getColumnCount();
                    int rowcount = ((ITableContent)child).getChildren().size();
                    if (columncount > 3 || rowcount > 1) {
                        logger.log(Level.WARNING, "Excel page header or footer only accept a table no more than 1 row and 3 columns.");
                        return false;
                    }
                    if (this.isEmbededTable((ITableContent)child)) {
                        logger.log(Level.WARNING, "Excel page header and footer don't support embeded grid.");
                        return false;
                    }
                }
                if (this.isHtmlText(child)) {
                    logger.log(Level.WARNING, "Excel page header and footer don't support html text.");
                    return false;
                }
                if (!(child instanceof IImageContent)) continue;
                logger.log(Level.WARNING, "Excel page header and footer don't support image.");
                return false;
            }
        }
        return true;
    }

    private boolean isHtmlText(Object child) {
        return child instanceof IForeignContent && "text/html".equalsIgnoreCase(((IForeignContent)child).getRawType());
    }

    private boolean isEmbededTable(ITableContent table) {
        boolean isEmbeded = false;
        Collection list = table.getChildren();
        for (Object child : list) {
            Collection listCell = ((IRowContent)child).getChildren();
            for (Object cellChild : listCell) {
                Collection listCellChild = ((ICellContent)cellChild).getChildren();
                for (Object cellchild : listCellChild) {
                    if (!(cellchild instanceof ITableContent)) continue;
                    isEmbeded = true;
                }
            }
        }
        return isEmbeded;
    }

    private void addBlankData(int column, int num, Data empty) {
        int i = 1;
        while (i <= num) {
            BlankData blank = new BlankData(empty);
            blank.setRowIndex(empty.getRowIndex());
            this.addDatatoCache(column + i, blank);
            ++i;
        }
    }

    private void addDatatoCache(int col, SheetData data) {
        this.currentCache.addData(col, data);
        BookmarkDef bookmark = data.getBookmark();
        this.addBookmark(bookmark);
    }

    public void addBookmark(BookmarkDef bookmark) {
        if (bookmark != null) {
            this.bookmarks.add(bookmark);
        }
    }

    protected void updataRowIndex(SheetData data, XlsContainer container) {
        int rowIndex = container.getEndRow() + 1;
        data.setRowIndex(rowIndex);
        container.setEndRow(rowIndex);
    }

    private void removeRightBorder(StyleEntry style) {
        style.setProperty(19, null);
        style.setProperty(20, null);
        style.setProperty(21, null);
    }

    private void removeLeftBorder(StyleEntry style) {
        style.setProperty(16, null);
        style.setProperty(17, null);
        style.setProperty(18, null);
    }

    private void removeTopBorder(StyleEntry style) {
        style.setProperty(13, null);
        style.setProperty(14, null);
        style.setProperty(15, null);
    }

    private void removeBottomBorder(StyleEntry style) {
        style.setProperty(10, null);
        style.setProperty(11, null);
        style.setProperty(12, null);
    }

    private void removeDiagonalLine(StyleEntry style) {
        style.setProperty(30, null);
        style.setProperty(31, null);
        style.setProperty(32, null);
        style.setProperty(33, null);
        style.setProperty(34, null);
        style.setProperty(35, null);
    }

    protected Data createData() {
        return new Data();
    }

    public Data createData(Object value, StyleEntry style) {
        return this.createData(value, style, 0);
    }

    protected Data createData(Object value, StyleEntry style, int rowSpanOfDesign) {
        Object property;
        int dataType = 2;
        if (style != null && (property = style.getProperty(25)) instanceof Integer) {
            dataType = (Integer)property;
        }
        int styleId = this.styleEngine.getStyleId(style);
        return this.createData(value, styleId, dataType, rowSpanOfDesign);
    }

    public Data createData(Object value, int styleId, int dataType, int rowSpanOfDesign) {
        Data data = this.createData();
        data.setDataType(dataType);
        data.setValue(value);
        if (styleId > 0) {
            data.setStyleId(styleId);
        }
        data.setRowSpanInDesign(rowSpanOfDesign);
        return data;
    }

    public void addEmptyDataToContainer(XlsContainer child, XlsContainer parent) {
        StyleEntry style;
        ContainerSizeInfo childSizeInfo = child.getSizeInfo();
        int childStartCoordinate = childSizeInfo.getStartCoordinate();
        int childEndCoordinate = childSizeInfo.getEndCoordinate();
        ContainerSizeInfo parentSizeInfo = parent.getSizeInfo();
        int parentStartCoordinate = parentSizeInfo.getStartCoordinate();
        int parentEndCoordinate = parent.getSizeInfo().getEndCoordinate();
        if (childEndCoordinate < parentEndCoordinate) {
            style = parent.getStyle();
            this.removeLeftBorder(style);
            this.removeDiagonalLine(style);
            this.addEmptyDataToContainer(style, parent, childEndCoordinate, parentEndCoordinate - childEndCoordinate);
        }
        if (childStartCoordinate > parentStartCoordinate) {
            style = parent.getStyle();
            this.removeRightBorder(style);
            this.removeDiagonalLine(style);
            this.addEmptyDataToContainer(style, parent, parentStartCoordinate, childStartCoordinate - parentStartCoordinate);
        }
    }

    public void addEmptyDataToContainer(StyleEntry style, XlsContainer parent, int startCoordinate, int width) {
        Data data = this.createEmptyData(style);
        data.setStartX(startCoordinate);
        data.setEndX(startCoordinate + width);
        this.addData(data, parent);
    }

    public double[] getCoordinates() {
        int[] columnWidths = this.axis.getColumnWidths();
        int count = Math.min(columnWidths.length, this.maxCol);
        double[] coord = new double[count];
        int i = 0;
        while (i < count) {
            coord[i] = columnWidths[i];
            ++i;
        }
        return coord;
    }

    public AxisProcessor getAxis() {
        return this.axis;
    }

    public int getStartColumn(SheetData data) {
        int start = this.axis.getColumnIndexByCoordinate(data.getStartX()) + 1;
        return Math.min(start, this.maxCol);
    }

    public int getEndColumn(SheetData data) {
        int end = this.axis.getColumnIndexByCoordinate(data.getEndX()) + 1;
        return Math.min(end, this.maxCol);
    }

    public void synchronize(float height, XlsContainer rowContainer) {
        ContainerSizeInfo rowSizeInfo = rowContainer.getSizeInfo();
        int startCoordinate = rowSizeInfo.getStartCoordinate();
        int endCoordinate = rowSizeInfo.getEndCoordinate();
        int startColumnIndex = this.axis.getColumnIndexByCoordinate(startCoordinate);
        int endColumnIndex = this.axis.getColumnIndexByCoordinate(endCoordinate);
        int maxRowIndex = 0;
        int[] rowIndexes = new int[endColumnIndex - startColumnIndex];
        int currentColumnIndex = startColumnIndex;
        while (currentColumnIndex < endColumnIndex) {
            int span;
            int rowIndex = this.currentCache.getMaxRowIndex(currentColumnIndex);
            SheetData lastData = this.currentCache.getColumnLastData(currentColumnIndex);
            rowIndexes[currentColumnIndex - startColumnIndex] = rowIndex;
            int n = span = lastData != null ? lastData.getRowSpanInDesign() : 0;
            if (span == 0 || span == 1 && !this.isInContainer(lastData, rowContainer)) {
                maxRowIndex = maxRowIndex > rowIndex ? maxRowIndex : rowIndex;
            }
            ++currentColumnIndex;
        }
        int startRowIndex = rowContainer.getEndRow();
        if (maxRowIndex <= startRowIndex) {
            maxRowIndex = startRowIndex + 1;
        }
        rowContainer.setEndRow(maxRowIndex);
        float resize = height / (float)(maxRowIndex - startRowIndex);
        if (resize == 0.0f || resize > 15.0f) {
            int i = startRowIndex;
            while (i < maxRowIndex) {
                this.currentCache.setRowHeight(i, resize);
                ++i;
            }
        }
        int currentColumnIndex2 = startColumnIndex;
        while (currentColumnIndex2 < endColumnIndex) {
            int rowspan = maxRowIndex - rowIndexes[currentColumnIndex2 - startColumnIndex];
            SheetData upstair = this.currentCache.getColumnLastData(currentColumnIndex2);
            if (rowspan > 0) {
                if (upstair != null && this.canSpan(upstair, rowContainer, currentColumnIndex2, endColumnIndex)) {
                    BlankData.Type blankType = BlankData.Type.VERTICAL;
                    if (upstair.isBlank()) {
                        BlankData blankData = (BlankData)upstair;
                        if (blankData.getType() == BlankData.Type.VERTICAL) {
                            upstair.setRowSpan(upstair.getRowSpan() + rowspan);
                            if (!this.isInContainer(blankData, rowContainer)) {
                                upstair.decreasRowSpanInDesign();
                            }
                        }
                        blankType = blankData.getType();
                    } else {
                        upstair.setRowSpan(upstair.getRowSpan() + rowspan);
                        if (!this.isInContainer(upstair, rowContainer)) {
                            upstair.decreasRowSpanInDesign();
                        }
                    }
                    int rowIndex = upstair.getRowIndex();
                    int p = 1;
                    while (p <= rowspan) {
                        BlankData blank = new BlankData(upstair);
                        blank.setRowIndex(rowIndex + p);
                        blank.setType(blankType);
                        this.currentCache.addData(currentColumnIndex2, blank);
                        ++p;
                    }
                } else if (upstair != null && this.isInContainer(upstair, rowContainer.getParent()) && (!upstair.isBlank() || ((BlankData)upstair).getType() == BlankData.Type.VERTICAL)) {
                    this.spanWithEmptyData(upstair, currentColumnIndex2, rowspan);
                }
            } else if (upstair != null && upstair.getRowSpanInDesign() > 0 && !this.isInContainer(upstair, rowContainer)) {
                upstair.decreasRowSpanInDesign();
            }
            ++currentColumnIndex2;
        }
    }

    private void spanWithEmptyData(SheetData sheetData, int currentColumnIndex, int rowspan) {
        SheetData ref = sheetData;
        while (ref.isBlank()) {
            if ((ref = ((BlankData)ref).getData()) != null) continue;
            return;
        }
        int rowIndex = sheetData.getRowIndex();
        int p = 1;
        while (p <= rowspan) {
            Data blank = this.createData();
            blank.setRowIndex(rowIndex + p);
            blank.setValue("");
            blank.setStartX(ref.getStartX());
            blank.setEndX(ref.getEndX());
            int styleId = sheetData.getStyleId();
            if (styleId != -1) {
                StyleEntry refStyle = this.styleEngine.getStyle(styleId);
                StyleEntry blankCellStyle = new StyleEntry(refStyle);
                this.removeTopBorder(blankCellStyle);
                blank.setStyleId(this.styleEngine.getStyleId(blankCellStyle));
                if (refStyle.getProperty(11) != null) {
                    StyleEntry refNewStyle = new StyleEntry(refStyle);
                    this.removeBottomBorder(refNewStyle);
                    sheetData.setStyleId(this.styleEngine.getStyleId(refNewStyle));
                }
            }
            this.currentCache.addData(currentColumnIndex, blank);
            ++p;
        }
    }

    public Data createEmptyData(StyleEntry style) {
        return this.createData(null, style);
    }

    private boolean isInContainer(SheetData data, XlsContainer rowContainer) {
        return data.getRowIndex() > rowContainer.getStartRow();
    }

    private boolean canSpan(SheetData data, XlsContainer rowContainer, int currentColumn, int lastColumn) {
        SheetData realData = ExcelUtil.getRealData(data);
        if (realData == null) {
            return false;
        }
        if (!this.isInContainer(realData, rowContainer) && realData.getRowSpanInDesign() <= 0) {
            return false;
        }
        int i = currentColumn + 1;
        while (i < lastColumn) {
            SheetData lastData = this.getColumnLastData(i);
            SheetData lastRealData = ExcelUtil.getRealData(lastData);
            if (lastRealData != null && lastRealData.getRowIndex() > realData.getRowIndex() && realData.getEndX() > lastRealData.getStartX()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void calculateRowHeight(SheetData[] rowData, boolean isAuto) {
        float rowHeight = 0.0f;
        int rowIndex = this.getRowIndex(rowData);
        float lastRowHeight = rowIndex > 0 ? this.currentCache.getRowHeight(rowIndex - 1) : 0.0f;
        boolean hasCurrentRowHeight = this.currentCache.hasRowHeight(rowIndex);
        if (!hasCurrentRowHeight || isAuto) {
            int i = 0;
            while (i < rowData.length) {
                SheetData data = rowData[i];
                if (data != null) {
                    int realDataRowEnd;
                    SheetData realData;
                    BlankData blankData;
                    if (data.isBlank() && (blankData = (BlankData)data).getType() == BlankData.Type.VERTICAL) {
                        data.setHeight(data.getHeight() - lastRowHeight);
                    }
                    if ((realData = ExcelUtil.getRealData(data)) != null && (realDataRowEnd = realData.getRowIndex() + realData.getRowSpan()) == data.getRowIndex()) {
                        rowHeight = data.getHeight() > rowHeight ? data.getHeight() : rowHeight;
                    }
                }
                ++i;
            }
            this.currentCache.setRowHeight(rowIndex, rowHeight);
        }
    }

    public SheetData getColumnLastData(int column) {
        return this.currentCache.getColumnLastData(column);
    }

    public Iterator<SheetData[]> getRowIterator() {
        return this.currentCache.getRowIterator();
    }

    public Iterator<SheetData[]> getRowIterator(DataCache.DataFilter filter, DataCache.RowIndexAdjuster rowIndexAdjuster) {
        return this.currentCache.getRowIterator(filter, rowIndexAdjuster);
    }

    public float getRowHeight(int rowIndex) {
        return this.currentCache.getRowHeight(rowIndex);
    }

    public List<BookmarkDef> getBookmarks() {
        return this.bookmarks;
    }

    private int getRowIndex(SheetData[] rowData) {
        int j = 0;
        while (j < rowData.length) {
            SheetData data = rowData[j];
            if (data != null) {
                return data.getRowIndex() - 1;
            }
            ++j;
        }
        return 0;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooter() {
        return this.footer;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public XlsContainer getPageContainer() {
        return this.pageContainer;
    }

    public void clearCache() {
        this.currentCache = null;
        this.caches = null;
        this.bookmarks = null;
    }

    public void finish() {
        for (BookmarkDef bookmark : this.bookmarks) {
            bookmark.setSheetName(this.sheetName);
            bookmark.setStartColumn(this.axis.getColumnIndexByCoordinate(bookmark.getStartColumn()) + 1);
            int endColumn = bookmark.getEndColumn();
            if (endColumn == -1) continue;
            bookmark.setEndColumn(this.axis.getColumnIndexByCoordinate(endColumn));
        }
    }
}

