/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Hierarchy;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.SecuredHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredDimension
extends Dimension {
    private static Logger logger = Logger.getLogger(Dimension.class.getName());
    private Set<String> inaccessibleLevels = new HashSet<String>();

    SecuredDimension(String name, IDocumentManager documentManager, Set<String> notAccessibleLevels) throws IOException, DataException {
        Object[] params = new Object[]{name, documentManager};
        logger.entering(SecuredDimension.class.getName(), "dimension", params);
        this.name = name;
        this.documentManager = documentManager;
        this.inaccessibleLevels = notAccessibleLevels;
        this.loadFromDisk();
        logger.exiting(SecuredDimension.class.getName(), "dimension");
    }

    @Override
    protected Hierarchy loadHierarchy(String hierarchyName) {
        return new SecuredHierarchy(this.documentManager, this.name, hierarchyName, this.inaccessibleLevels);
    }
}

