/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.TimeResultRow;
import org.eclipse.birt.data.engine.olap.data.util.DataType;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationResultSet
implements IAggregationResultSet {
    private AggregationDefinition aggregation;
    private DimLevel[] levels;
    private Map<String, Integer> aggregationResultNameMap = null;
    private IDiskArray aggregationResultRows;
    List<TimeResultRow> timeResultSet;
    private int currentPosition;
    private String[][] keyNames;
    private String[][] attributeNames;
    private int[][] keyDataTypes;
    private int[][] attributeDataTypes;
    private int[] aggregationDataType;
    private IAggregationResultRow resultObject;
    private static Logger logger = Logger.getLogger(AggregationResultSet.class.getName());

    public AggregationResultSet(AggregationDefinition aggregation, IDiskArray aggregationResultRow, String[][] keyNames, String[][] attributeNames) throws IOException {
        Object[] params = new Object[]{aggregation, aggregationResultRow, keyNames, attributeNames};
        logger.entering(AggregationResultSet.class.getName(), "AggregationResultSet", params);
        this.aggregation = aggregation;
        this.levels = aggregation.getLevels();
        this.aggregationResultRows = aggregationResultRow;
        this.produceaggregationNameMap();
        this.keyNames = keyNames;
        this.attributeNames = attributeNames;
        int aggrCount = 0;
        if (aggregation.getAggregationFunctions() != null) {
            aggrCount = aggregation.getAggregationFunctions().length;
        }
        this.aggregationDataType = new int[aggrCount];
        Arrays.fill(this.aggregationDataType, -1);
        if (aggregationResultRow.size() == 0) {
            return;
        }
        this.resultObject = (IAggregationResultRow)aggregationResultRow.get(0);
        if (this.resultObject.getLevelMembers() != null) {
            this.keyDataTypes = new int[this.resultObject.getLevelMembers().length][];
            this.attributeDataTypes = new int[this.resultObject.getLevelMembers().length][];
            int i = 0;
            while (i < this.resultObject.getLevelMembers().length) {
                if (this.resultObject.getLevelMembers()[i] != null) {
                    this.keyDataTypes[i] = new int[this.resultObject.getLevelMembers()[i].getKeyValues().length];
                    int j = 0;
                    while (j < this.resultObject.getLevelMembers()[i].getKeyValues().length) {
                        this.keyDataTypes[i][j] = DataType.getDataType(this.resultObject.getLevelMembers()[i].getKeyValues()[j].getClass());
                        ++j;
                    }
                    if (this.resultObject.getLevelMembers()[i].getAttributes() != null) {
                        this.attributeDataTypes[i] = new int[this.resultObject.getLevelMembers()[i].getAttributes().length];
                        j = 0;
                        while (j < this.attributeDataTypes[i].length) {
                            if (this.resultObject.getLevelMembers()[i].getAttributes()[j] != null) {
                                this.attributeDataTypes[i][j] = DataType.getDataType(this.resultObject.getLevelMembers()[i].getAttributes()[j].getClass());
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        this.setAggregationDataType();
        logger.exiting(AggregationResultSet.class.getName(), "AggregationResultSet");
    }

    public AggregationResultSet(AggregationDefinition aggregation, DimLevel[] levels, IDiskArray aggregationResultRow, String[][] keyNames, String[][] attributeNames) throws IOException {
        this(aggregation, aggregationResultRow, keyNames, attributeNames);
        this.levels = levels;
    }

    private void setAggregationDataType() throws IOException {
        IAggregationResultRow resultObject = null;
        int i = 0;
        while (i < this.aggregationResultRows.size()) {
            resultObject = (IAggregationResultRow)this.aggregationResultRows.get(i);
            if (resultObject.getAggregationValues() != null) {
                boolean existUnknown = false;
                int j = 0;
                while (j < resultObject.getAggregationValues().length) {
                    if (this.aggregationDataType[j] == -1) {
                        if (resultObject.getAggregationValues()[j] != null) {
                            this.aggregationDataType[j] = DataType.getDataType(resultObject.getAggregationValues()[j].getClass());
                        } else {
                            existUnknown = true;
                        }
                    }
                    ++j;
                }
                if (!existUnknown) {
                    return;
                }
            }
            ++i;
        }
    }

    private void setTimeDataType() throws IOException {
        TimeResultRow timeResultRow = null;
        int[] timeAggregationDataType = null;
        int i = 0;
        while (i < this.timeResultSet.size()) {
            timeResultRow = this.timeResultSet.get(0);
            if (timeResultRow.getValue() != null) {
                boolean existUnknown = false;
                if (timeAggregationDataType == null) {
                    timeAggregationDataType = new int[timeResultRow.getValue().length];
                }
                int j = 0;
                while (j < timeResultRow.getValue().length) {
                    if (timeAggregationDataType[j] == -1) {
                        if (timeResultRow.getValue()[j] != null) {
                            timeAggregationDataType[j] = DataType.getDataType(timeResultRow.getValue()[j].getClass());
                        } else {
                            existUnknown = true;
                        }
                    }
                    ++j;
                }
                if (!existUnknown) break;
            }
            ++i;
        }
    }

    private void produceaggregationNameMap() {
        AggregationFunctionDefinition[] functions = this.aggregation.getAggregationFunctions();
        this.aggregationResultNameMap = new HashMap<String, Integer>();
        if (functions == null) {
            return;
        }
        int i = 0;
        while (i < functions.length) {
            if (functions[i].getName() != null) {
                this.aggregationResultNameMap.put(functions[i].getName(), i);
            }
            ++i;
        }
    }

    @Override
    public int getAggregationDataType(int aggregationIndex) throws IOException {
        if (this.aggregationDataType == null || aggregationIndex < 0) {
            return -1;
        }
        return this.aggregationDataType[aggregationIndex];
    }

    @Override
    public int[] getAggregationDataType() {
        return this.aggregationDataType;
    }

    @Override
    public Object getAggregationValue(int aggregationIndex) throws IOException {
        if (this.resultObject.getAggregationValues() == null || aggregationIndex < 0) {
            return null;
        }
        return this.resultObject.getAggregationValues()[aggregationIndex];
    }

    @Override
    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || this.resultObject.getLevelMembers()[levelIndex].getAttributes() == null) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getAttributes()[attributeIndex];
    }

    @Override
    public Object[] getLevelAttributesValue(int levelIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || this.resultObject.getLevelMembers()[levelIndex].getAttributes() == null) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getAttributes();
    }

    @Override
    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeDataTypes == null || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(level, attributeName)];
    }

    @Override
    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeNames == null || this.attributeNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.attributeNames[levelIndex].length) {
            if (this.attributeNames[levelIndex][i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        if (this.attributeNames == null || levelIndex < 0 || this.attributeNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.attributeNames[levelIndex].length) {
            if (this.attributeNames[levelIndex][i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLevelIndex(DimLevel level) {
        if (this.levels == null) {
            return -1;
        }
        int i = 0;
        while (i < this.levels.length) {
            if (this.levels[i].equals(level)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLevelKeyDataType(DimLevel level, String keyName) {
        if (this.keyDataTypes == null) {
            return -1;
        }
        return this.getLevelKeyDataType(this.getLevelIndex(level), keyName);
    }

    @Override
    public Object[] getLevelKeyValue(int levelIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || levelIndex > this.resultObject.getLevelMembers().length - 1 || this.resultObject.getLevelMembers()[levelIndex] == null) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getKeyValues();
    }

    @Override
    public int length() {
        return this.aggregationResultRows.size();
    }

    @Override
    public void seek(int index) throws IOException {
        if (index >= this.aggregationResultRows.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.aggregationResultRows.size());
        }
        this.currentPosition = index;
        this.resultObject = (IAggregationResultRow)this.aggregationResultRows.get(index);
        if (this.timeResultSet != null) {
            Object[] aggrValues = this.resultObject.getAggregationValues();
            Object[] tAggrValues = this.timeResultSet.get(this.currentPosition).getValue();
            System.arraycopy(tAggrValues, 0, aggrValues, aggrValues.length - tAggrValues.length, tAggrValues.length);
        }
    }

    @Override
    public IAggregationResultRow getCurrentRow() {
        return this.resultObject;
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    @Override
    public int getSortType(int levelIndex) {
        if (this.aggregation.getSortTypes() == null) {
            return -100;
        }
        return this.aggregation.getSortTypes()[levelIndex];
    }

    @Override
    public int[] getSortType() {
        return this.aggregation.getSortTypes();
    }

    @Override
    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        if (this.attributeDataTypes == null || levelIndex < 0 || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(levelIndex, attributeName)];
    }

    @Override
    public String[] getLevelAttributes(int levelIndex) {
        if (this.attributeNames == null) {
            return null;
        }
        return this.attributeNames[levelIndex];
    }

    @Override
    public int getLevelKeyDataType(int levelIndex, String keyName) {
        if (this.keyDataTypes == null || levelIndex < 0 || this.keyDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.keyDataTypes[levelIndex][this.getLevelKeyIndex(levelIndex, keyName)];
    }

    @Override
    public int getLevelKeyIndex(int levelIndex, String keyName) {
        if (this.keyNames == null || levelIndex < 0 || this.keyNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.keyNames[levelIndex].length) {
            if (this.keyNames[levelIndex][i].equals(keyName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLevelKeyIndex(DimLevel level, String keyName) {
        if (this.keyNames == null) {
            return -1;
        }
        return this.getLevelKeyIndex(this.getLevelIndex(level), keyName);
    }

    @Override
    public int getLevelAttributeColCount(int levelIndex) {
        if (this.attributeNames == null || this.attributeNames[levelIndex] == null) {
            return 0;
        }
        return this.attributeNames[levelIndex].length;
    }

    @Override
    public int getLevelKeyColCount(int levelIndex) {
        if (this.keyNames == null || this.keyNames[levelIndex] == null) {
            return 0;
        }
        return this.keyNames[levelIndex].length;
    }

    @Override
    public String[][] getLevelKeys() {
        return this.keyNames;
    }

    @Override
    public int[][] getLevelKeyDataType() {
        return this.keyDataTypes;
    }

    @Override
    public String[][] getLevelAttributes() {
        return this.attributeNames;
    }

    @Override
    public int[][] getLevelAttributeDataType() {
        return this.attributeDataTypes;
    }

    @Override
    public int getLevelCount() {
        if (this.keyNames == null) {
            return 0;
        }
        return this.keyNames.length;
    }

    @Override
    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.keyNames[levelIndex][keyIndex];
    }

    @Override
    public DimLevel getLevel(int levelIndex) {
        return this.levels[levelIndex];
    }

    @Override
    public String[][] getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public String[][] getKeyNames() {
        return this.keyNames;
    }

    @Override
    public int getAggregationIndex(String name) throws IOException {
        Integer index = this.aggregationResultNameMap.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public DimLevel[] getAllLevels() {
        return this.levels;
    }

    @Override
    public AggregationDefinition getAggregationDefinition() {
        return this.aggregation;
    }

    @Override
    public void close() throws IOException {
        this.aggregationResultRows.close();
    }

    @Override
    public void clear() throws IOException {
        this.aggregationResultRows.clear();
    }

    public void addTimeFunctionResultSet(List<TimeResultRow> timeResultSet) throws IOException {
        this.timeResultSet = timeResultSet;
        this.setTimeDataType();
    }

    @Override
    public int getAggregationCount() {
        return this.aggregation.getAggregationFunctions() == null ? 0 : this.aggregation.getAggregationFunctions().length;
    }

    @Override
    public String getAggregationName(int index) {
        if (this.aggregation.getAggregationFunctions() != null) {
            return this.aggregation.getAggregationFunctions()[index].getName();
        }
        return null;
    }

    public IDiskArray getAggregationResultRows() {
        return this.aggregationResultRows;
    }

    public void setAggregationResultRows(IDiskArray rows) {
        this.aggregationResultRows = rows;
    }
}

