/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.IServiceForResultSet;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.RowIDUtil;
import org.eclipse.birt.data.engine.impl.SummaryGroupLevelCalculator;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultIterator2
extends ResultIterator {
    private int lowestGroupLevel;
    private int currRowIndex;
    private int cachedRowId;
    private boolean isSummary;
    private SummaryGroupLevelCalculator groupLevelCalculator;
    private static Logger logger = Logger.getLogger(ResultIterator2.class.getName());
    private StreamManager streamManager = null;
    private DataOutputStream dataSetStream = null;
    private DataOutputStream dataSetLenStream = null;
    private RAOutputStream raDataSet = null;
    private long offset = 4L;
    private long rowCountOffset = 0L;
    private boolean saveToDoc = false;
    private List<IBinding> bindings = null;

    ResultIterator2(IServiceForResultSet rService, IResultIterator odiResult, Scriptable scope, int rawIdStartingValue) throws DataException {
        super(rService, odiResult, scope, rawIdStartingValue);
        Object[] params = new Object[]{rService, odiResult, scope};
        logger.entering(ResultIterator2.class.getName(), "ResultIterator2", params);
        this.lowestGroupLevel = rService.getQueryDefn().getGroups().size();
        this.currRowIndex = -1;
        this.cachedRowId = 0;
        boolean bl = this.isSummary = rService.getQueryDefn() instanceof IQueryDefinition ? ((IQueryDefinition)rService.getQueryDefn()).isSummaryQuery() : false;
        if (this.isSummary) {
            if (this.lowestGroupLevel == 0) {
                this.groupLevelCalculator = new SummaryGroupLevelCalculator(null);
            } else {
                int[][] groupIndex = new int[this.lowestGroupLevel + 1][];
                int i = 0;
                while (i <= this.lowestGroupLevel) {
                    groupIndex[i] = this.odiResult.getGroupStartAndEndIndex(i);
                    ++i;
                }
                this.groupLevelCalculator = new SummaryGroupLevelCalculator(groupIndex);
            }
            if (rService.getSession().getEngineContext().getMode() == 1) {
                this.saveToDoc = true;
                this.streamManager = new StreamManager(rService.getSession().getEngineContext(), new QueryResultInfo(rService.getQueryResults().getID(), null, 0));
                try {
                    this.bindings = this.findSavedBinding(rService.getQueryDefn().getBindings());
                    this.doSaveResultClass(this.streamManager.getOutStream(22, 0, 2), this.bindings);
                    this.raDataSet = (RAOutputStream)this.streamManager.getOutStream(21, 0, 2);
                    this.rowCountOffset = this.raDataSet.getOffset();
                    this.dataSetStream = new DataOutputStream(this.raDataSet);
                    IOUtil.writeInt(this.dataSetStream, -1);
                    this.dataSetLenStream = new DataOutputStream(this.streamManager.getOutStream(23, 0, 2));
                }
                catch (Exception e) {
                    throw new DataException(e.getLocalizedMessage());
                }
            }
        }
        logger.exiting(ResultIterator2.class.getName(), "ResultIterator2");
    }

    private List<IBinding> findSavedBinding(Map bindingMap) {
        Iterator bindingIt = bindingMap.values().iterator();
        ArrayList<IBinding> bindingList = new ArrayList<IBinding>();
        while (bindingIt.hasNext()) {
            IBinding binding = (IBinding)bindingIt.next();
            List referencedBindings = new ArrayList();
            try {
                if (binding.getAggrFunction() != null) {
                    IBaseExpression expr = binding.getExpression();
                    if (expr != null) {
                        referencedBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "dataSetRow");
                    }
                    if (!referencedBindings.isEmpty()) {
                        bindingList.add(binding);
                        continue;
                    }
                    for (IBaseExpression argExpr : binding.getArguments()) {
                        referencedBindings = ExpressionCompilerUtil.extractColumnExpression(argExpr, "dataSetRow");
                        if (!referencedBindings.isEmpty()) break;
                    }
                    if (!referencedBindings.isEmpty()) {
                        bindingList.add(binding);
                        continue;
                    }
                    boolean needRecalcualte = false;
                    if (expr != null) {
                        referencedBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "row");
                        int i = 0;
                        while (i < referencedBindings.size()) {
                            IBinding b = (IBinding)bindingMap.get(referencedBindings.get(i));
                            if (b != null && b.getAggrFunction() != null) {
                                needRecalcualte = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (needRecalcualte) continue;
                    for (IBaseExpression argExpr : binding.getArguments()) {
                        referencedBindings = ExpressionCompilerUtil.extractColumnExpression(argExpr, "row");
                        int i = 0;
                        while (i < referencedBindings.size()) {
                            IBinding b = (IBinding)bindingMap.get(referencedBindings.get(i));
                            if (b != null && b.getAggrFunction() != null) {
                                needRecalcualte = true;
                                break;
                            }
                            ++i;
                        }
                        if (needRecalcualte) break;
                    }
                    if (needRecalcualte) continue;
                    bindingList.add(binding);
                    continue;
                }
                bindingList.add(binding);
            }
            catch (DataException dataException) {
                bindingList.add(binding);
            }
        }
        return bindingList;
    }

    private void doSaveResultClass(OutputStream outputStream, List<IBinding> requestColumnMap) throws BirtException {
        assert (outputStream != null);
        DataOutputStream dos = new DataOutputStream(outputStream);
        try {
            IOUtil.writeInt(outputStream, requestColumnMap.size());
            int i = 0;
            while (i < requestColumnMap.size()) {
                IBinding binding = requestColumnMap.get(i);
                IOUtil.writeInt(dos, i + 1);
                IOUtil.writeString(dos, binding.getBindingName());
                IOUtil.writeString(dos, null);
                IOUtil.writeString(dos, null);
                IOUtil.writeString(dos, this.getDataTypeClass(binding).getName());
                IOUtil.writeString(dos, null);
                IOUtil.writeBool(dos, false);
                IOUtil.writeString(dos, null);
                if (this.streamManager.getVersion() >= 130) {
                    IOUtil.writeInt(dos, -1);
                    IOUtil.writeString(dos, null);
                    IOUtil.writeBool(dos, false);
                    IOUtil.writeBool(dos, false);
                }
                ++i;
            }
            dos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, (Object)"Result Class");
        }
    }

    private Class getDataTypeClass(IBinding binding) throws DataException {
        Class clazz = DataType.getClass(binding.getDataType());
        return clazz == null ? String.class : clazz;
    }

    @Override
    public boolean next() throws BirtException {
        boolean hasNext = super.next();
        if (hasNext) {
            ++this.currRowIndex;
        } else if (this.currRowIndex == -1) {
            this.cachedRowId = -1;
        }
        return hasNext;
    }

    @Override
    protected boolean hasNextRow() throws DataException {
        boolean result = false;
        int index = this.odiResult.getCurrentResultIndex();
        this.odiResult.last(this.lowestGroupLevel);
        if (this.isSummary) {
            result = this.odiResult.next();
            if (this.saveToDoc) {
                try {
                    IOUtil.writeLong(this.dataSetLenStream, this.offset);
                    this.offset += (long)this.writeResultObject(this.boundColumnValueMap);
                }
                catch (IOException e) {
                    throw new DataException(e.getLocalizedMessage());
                }
            }
        } else {
            boolean shouldMoveForward = false;
            if (index != this.odiResult.getCurrentResultIndex()) {
                result = this.odiResult.getCurrentResult() != null;
                shouldMoveForward = false;
            } else {
                shouldMoveForward = true;
            }
            if (shouldMoveForward) {
                result = this.odiResult.next();
            }
        }
        if (result) {
            IResultObject ob;
            if (this.rowIDUtil == null) {
                this.rowIDUtil = new RowIDUtil();
            }
            this.cachedRowId = this.rowIDUtil.getMode(this.odiResult) == 1 ? this.odiResult.getCurrentResultIndex() : ((ob = this.odiResult.getCurrentResult()) == null ? -1 : (Integer)ob.getFieldValue(this.rowIDUtil.getRowIdPos()));
        }
        return result;
    }

    private int writeResultObject(Map valueMap) throws DataException, IOException {
        ByteArrayOutputStream tempBaos = new ByteArrayOutputStream();
        BufferedOutputStream tempBos = new BufferedOutputStream(tempBaos);
        DataOutputStream tempDos = new DataOutputStream(tempBos);
        for (IBinding binding : this.bindings) {
            if (this.streamManager.getVersion() >= 200) {
                ResultObjectUtil.writeObject(tempDos, valueMap.get(binding.getBindingName()), this.getDataTypeClass(binding));
                continue;
            }
            IOUtil.writeObject(tempDos, valueMap.get(binding.getBindingName()));
        }
        tempDos.flush();
        tempBos.flush();
        tempBaos.flush();
        byte[] bytes = tempBaos.toByteArray();
        int rowBytes = bytes.length;
        IOUtil.writeRawBytes(this.dataSetStream, bytes);
        tempBaos = null;
        tempBos = null;
        tempDos = null;
        return rowBytes;
    }

    @Override
    public void close() throws BirtException {
        super.close();
        if (this.saveToDoc) {
            try {
                this.saveToDoc = false;
                this.raDataSet.seek(this.rowCountOffset);
                IOUtil.writeInt(this.dataSetStream, this.currRowIndex + 1);
                this.dataSetLenStream.close();
                this.dataSetStream.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public int getRowId() throws BirtException {
        return this.cachedRowId;
    }

    @Override
    public int getEndingGroupLevel() throws DataException {
        if (this.isSummary) {
            return this.groupLevelCalculator.getEndingGroupLevel(this.odiResult.getCurrentResultIndex());
        }
        return super.getEndingGroupLevel();
    }

    @Override
    public int getRowIndex() throws BirtException {
        return this.currRowIndex;
    }

    @Override
    public void moveTo(int rowIndex) throws BirtException {
        if (rowIndex < 0 || rowIndex < this.currRowIndex) {
            throw new DataException("data.engine.invalidRowIndex", rowIndex);
        }
        if (rowIndex == this.currRowIndex) {
            return;
        }
        int gapRows = rowIndex - this.currRowIndex;
        int i = 0;
        while (i < gapRows) {
            if (!this.next()) {
                throw new DataException("data.engine.invalidRowIndex", rowIndex);
            }
            ++i;
        }
    }

    @Override
    protected void goThroughGapRows(int groupLevel) throws DataException, BirtException {
        this.odiResult.last(groupLevel);
    }
}

