/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.IReportDesign;
import org.eclipse.birt.report.model.api.simpleapi.IStyle;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.simpleapi.ElementUtil;
import org.eclipse.birt.report.model.simpleapi.ReportDesign;
import org.eclipse.birt.report.model.simpleapi.Style;

public class DesignElement
implements IDesignElement {
    protected DesignElementHandle handle;

    public DesignElement(DesignElementHandle handle) {
        this.handle = handle;
    }

    public IStyle getStyle() {
        return new Style(this.handle.getPrivateStyle());
    }

    public String getQualifiedName() {
        return this.handle.getQualifiedName();
    }

    public String getNamedExpression(String name) {
        UserPropertyDefnHandle propDefn = this.handle.getUserPropertyDefnHandle(name);
        Object userProp = this.getUserProperty(name);
        if (propDefn == null || userProp == null || propDefn.getType() != 7) {
            return null;
        }
        return userProp.toString();
    }

    public void setNamedExpression(String name, String exp) throws SemanticException {
        UserPropertyDefnHandle propDefn = this.handle.getUserPropertyDefnHandle(name);
        if (propDefn == null) {
            this.addUserProperty(name, "expression");
        } else if (propDefn.getType() != 7) {
            return;
        }
        this.setUserProperty(name, exp);
    }

    public Object getUserProperty(String name) {
        return this.handle.getProperty(name);
    }

    public void setUserProperty(String name, String value) throws SemanticException {
        if (this.handle.getUserPropertyDefnHandle(name) == null) {
            this.addUserProperty(name, "string");
        }
        this.handle.setProperty(name, value);
    }

    public void setUserProperty(String name, Object value, String type) throws SemanticException {
        if (this.handle.getUserPropertyDefnHandle(name) == null) {
            this.addUserProperty(name, type);
        }
        this.handle.setProperty(name, value);
    }

    public IDesignElement getParent() {
        return ElementUtil.getElement(this.handle.getContainer());
    }

    private void addUserProperty(String name, String type) throws SemanticException {
        UserPropertyDefn newProp = new UserPropertyDefn();
        newProp.setName(name);
        newProp.setType(MetaDataDictionary.getInstance().getPropertyType(type));
        this.handle.addUserPropertyDefn(newProp);
    }

    public IReportDesign getReport() {
        if (this.handle == null) {
            return null;
        }
        ModuleHandle root = this.handle.getRoot();
        if (!(root instanceof ReportDesignHandle)) {
            return null;
        }
        return new ReportDesign((ReportDesignHandle)root);
    }

    protected void setProperty(String propName, Object value) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            this.handle.setProperty(propName, value);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public Object getUserPropertyExpression(String name) {
        return this.handle.getProperty(name);
    }
}

