/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.DataEngineThreadLocal;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.CachedQueryResults;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetDesignHelper;
import org.eclipse.birt.data.engine.impl.DataSourceManager;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.EngineExecutionHints;
import org.eclipse.birt.data.engine.impl.IEngineExecutionHints;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.impl.MemoryUsageSetting;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.QueryPrepareUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedSubCubeQuery;
import org.eclipse.birt.data.engine.script.JSDataSources;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.mozilla.javascript.Scriptable;

public class DataEngineImpl
extends DataEngine {
    private HashMap dataSources = new HashMap();
    private HashMap dataSetDesigns = new HashMap();
    private HashMap dataSourceDesigns = new HashMap();
    private Scriptable dataSourcesJSObject;
    private DataEngineContext context;
    private DataEngineSession session;
    private DataSourceManager dataSourceManager;
    private Map<String, String> cubeDataSourceMap = new HashMap<String, String>();
    private Map<String, String> cubeDataObjectMap = new HashMap<String, String>();
    private List shutdownListenerList = null;
    private IEngineExecutionHints queryExecutionHints;
    private Map<DataSourceAndDataSetNames, ValidationContext> validationContextMap = new HashMap<DataSourceAndDataSetNames, ValidationContext>();
    private static final String BIRT_ENGINE_BUNDEL_VERSION = "BIRT ENGINE BUILD NUMBER";
    protected static Logger logger = Logger.getLogger(DataEngineImpl.class.getName());

    public DataEngineImpl(DataEngineContext context) throws BirtException {
        assert (context != null);
        logger.entering(DataEngineImpl.class.getName(), "DataEngineImpl", context);
        this.queryExecutionHints = new EngineExecutionHints();
        this.context = context;
        this.dataSourceManager = new DataSourceManager(logger);
        this.session = new DataEngineSession(this);
        DataEngineThreadLocal.getInstance().getCloseListener().dataEngineStart();
        logger.exiting(DataEngineImpl.class.getName(), "DataEngineImpl");
        logger.log(Level.FINER, "Data Engine starts up");
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public IQueryResults getQueryResults(String queryResultID) throws DataException {
        if (this.context.getMode() == 2 || this.context.getMode() == 4 && this.context.getDocWriter() == null) {
            return new QueryResults(this.session.getTempDir(), this.context, queryResultID);
        }
        if (this.context.getMode() == 1 || this.context.getMode() == 3) {
            return new CachedQueryResults(this.session, queryResultID, null, null);
        }
        return null;
    }

    public void defineDataSource(IBaseDataSourceDesign dataSource) throws DataException {
        DataSourceRuntime newDefn;
        Object existingDefn;
        logger.entering(DataEngineImpl.class.getName(), "defineDataSource", dataSource == null ? "<null>" : dataSource.getName());
        if (dataSource == null) {
            NullPointerException e = new NullPointerException("dataSource param cannot be null");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "dataSource param cannot be null", e);
            throw e;
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        String name = dataSource.getName();
        if (name == null || name.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Data source has no name");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "Data source has no name", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, DataEngineImpl.class.getName(), "defineDataSource", "DataEngine.defineDataSource: " + LogUtil.toString(dataSource));
        }
        if ((existingDefn = this.dataSources.get(dataSource.getName())) != null) {
            this.dataSourceManager.addDataSource((DataSourceRuntime)existingDefn);
        }
        if ((newDefn = DataSourceRuntime.newInstance(dataSource, this)) != null) {
            this.dataSources.put(newDefn.getName(), newDefn);
        }
        this.dataSourceDesigns.put(dataSource.getName(), dataSource);
        logger.exiting(DataEngineImpl.class.getName(), "defineDataSource");
    }

    public void defineDataSet(IBaseDataSetDesign dataSet) throws DataException {
        logger.entering(DataEngineImpl.class.getName(), "defineDataSet", dataSet == null ? "<null>" : dataSet.getName());
        if (dataSet == null) {
            NullPointerException e = new NullPointerException("dataSource param cannot be null");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "dataSource param cannot be null", e);
            throw e;
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "DataEngine has been shutdown", e);
            throw e;
        }
        String name = dataSet.getName();
        if (name == null || name.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Data source has no name");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Data source has no name", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, DataEngineImpl.class.getName(), "defineDataSet", "DataEngine.defineDataSet: " + LogUtil.toString(dataSet));
        }
        DataSetDesignHelper.vailidateDataSetDesign(dataSet, this.dataSourceDesigns);
        this.dataSetDesigns.put(name, dataSet);
        logger.exiting(DataEngineImpl.class.getName(), "defineDataSet");
    }

    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        if (dataSource == null || dataSet == null) {
            return;
        }
        DataSetCacheManager dscManager = this.getSession().getDataSetCacheManager();
        if (dscManager == null) {
            return;
        }
        dscManager.clearCache(dataSource, dataSet);
    }

    public DataSourceRuntime getDataSourceRuntime(String name) {
        return (DataSourceRuntime)this.dataSources.get(name);
    }

    public IBaseDataSetDesign getDataSetDesign(String name) {
        return (IBaseDataSetDesign)this.dataSetDesigns.get(name);
    }

    public IBaseDataSourceDesign getDataSourceDesign(String name) {
        return (IBaseDataSourceDesign)this.dataSourceDesigns.get(name);
    }

    public IPreparedQuery prepare(IQueryDefinition querySpec) throws DataException {
        return this.prepare(querySpec, null);
    }

    public IPreparedCubeQuery prepare(ISubCubeQueryDefinition querySpec, Map appContext) throws BirtException {
        this.setMemoryUsage(appContext);
        return new PreparedSubCubeQuery(querySpec, appContext, this.session);
    }

    private void setMemoryUsage(Map appContext) {
        String memoryUsage = null;
        if (appContext != null) {
            memoryUsage = (String)appContext.get(DataEngine.MEMORY_USAGE);
        }
        MemoryUsageSetting.setMemoryUsage(memoryUsage);
    }

    public IPreparedQuery prepare(IQueryDefinition querySpec, Map appContext) throws DataException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(DataEngineImpl.class.getName(), "prepare", LogUtil.toString(querySpec));
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "prepare", "DataEngine has been shutdown", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("Start to prepare query: " + LogUtil.toString(querySpec));
        }
        this.setMemoryUsage(appContext);
        if (appContext != null) {
            this.context.setBundleVersion((String)appContext.get(BIRT_ENGINE_BUNDEL_VERSION));
        }
        IPreparedQuery result = PreparedQueryUtil.newInstance(this, querySpec, appContext);
        logger.fine("Finished preparing query.");
        logger.exiting(DataEngineImpl.class.getName(), "prepare");
        return result;
    }

    public void closeDataSource(String dataSourceName) throws DataException {
        logger.entering("DataEngineImpl", "closeDataSource", dataSourceName);
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "closeDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        logger.logp(Level.FINER, DataEngineImpl.class.getName(), "closeDataSource", "Close DataSource :" + dataSourceName);
        DataSourceRuntime ds = this.getDataSourceRuntime(dataSourceName);
        if (ds != null) {
            DataEngineImpl.closeDataSource(ds);
        }
        logger.exiting(DataEngineImpl.class.getName(), "closeDataSource");
    }

    private static void closeDataSource(DataSourceRuntime ds) throws DataException {
        assert (ds != null);
        if (ds.isOpen()) {
            ds.beforeClose();
            ds.closeOdiDataSource();
            ds.afterClose();
        }
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    public void defineCube(String cubeName, String dataSourceName, String dataObjectName) {
        this.cubeDataSourceMap.put(cubeName, dataSourceName);
        this.cubeDataObjectMap.put(cubeName, dataObjectName);
    }

    public void addShutdownListener(IShutdownListener listener) {
        if (this.shutdownListenerList == null) {
            this.shutdownListenerList = new ArrayList();
        }
        int i = 0;
        while (i < this.shutdownListenerList.size()) {
            if (listener == this.shutdownListenerList.get(i)) {
                return;
            }
            ++i;
        }
        this.shutdownListenerList.add(listener);
    }

    public void removeListener(IShutdownListener listener) {
        if (this.shutdownListenerList == null) {
            return;
        }
        int i = 0;
        while (i < this.shutdownListenerList.size()) {
            if (listener == this.shutdownListenerList.get(i)) {
                this.shutdownListenerList.remove(i);
                return;
            }
            ++i;
        }
    }

    public void shutdown() {
        logger.entering("DataEngineImpl", "shutdown");
        if (this.dataSources == null) {
            logger.fine("The data engine has already been shutdown");
            return;
        }
        Collection col = this.dataSources.values();
        for (DataSourceRuntime ds : col) {
            try {
                DataEngineImpl.closeDataSource(ds);
            }
            catch (DataException e) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "The data source (" + ds + ") fails to shut down", e);
            }
        }
        this.dataSourceManager.close();
        this.releaseValidationContexts();
        if (this.shutdownListenerList != null) {
            int i = 0;
            while (i < this.shutdownListenerList.size()) {
                ((IShutdownListener)this.shutdownListenerList.get(i)).dataEngineShutdown();
                ++i;
            }
            this.shutdownListenerList.clear();
        }
        logger.logp(Level.FINE, DataEngineImpl.class.getName(), "shutdown", "Data engine shuts down");
        this.dataSetDesigns = null;
        this.dataSources = null;
        try {
            DataEngineThreadLocal.getInstance().getCloseListener().dataEngineShutDown();
            DataEngineThreadLocal.getInstance().removeTempPathManger();
            if (DataEngineThreadLocal.getInstance().getCloseListener().getActivateDteCount() == 0) {
                DataEngineThreadLocal.getInstance().getCloseListener().closeAll();
                DataEngineThreadLocal.getInstance().removeCloseListener();
            }
            this.clearTempFile();
        }
        catch (IOException iOException) {}
        if (this.getContext().getDocWriter() != null) {
            try {
                RAOutputStream outputStream = this.getContext().getDocWriter().exists("/dataEngine/queryStartingID") ? this.getContext().getDocWriter().getOutputStream("/dataEngine/queryStartingID") : this.getContext().getDocWriter().createOutputStream("/dataEngine/queryStartingID");
                outputStream.writeInt(this.getSession().getQueryResultIDUtil().getCurrentQueryId());
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.exiting(DataEngineImpl.class.getName(), "shutdown");
    }

    private void clearTempFile() {
        File tmpDir = new File(this.session.getTempDir());
        if (!FileSecurity.fileExist(tmpDir) || !FileSecurity.fileIsDirectory(tmpDir)) {
            return;
        }
        DataEngineImpl.deleteDirectory(tmpDir);
    }

    private static void deleteDirectory(File dir) {
        File[] subFiles = FileSecurity.fileListFiles(dir);
        if (subFiles != null) {
            int i = 0;
            while (i < subFiles.length) {
                if (FileSecurity.fileIsDirectory(subFiles[i])) {
                    DataEngineImpl.deleteDirectory(subFiles[i]);
                } else {
                    DataEngineImpl.safeDelete(subFiles[i]);
                }
                ++i;
            }
        }
        DataEngineImpl.safeDelete(dir);
    }

    private static void safeDelete(File file) {
        if (!FileSecurity.fileDelete(file)) {
            FileSecurity.fileDeleteOnExit(file);
        }
    }

    public Scriptable getDataSourcesScriptObject() {
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "closeDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        if (this.dataSourcesJSObject == null) {
            this.dataSourcesJSObject = new JSDataSources(this.dataSources);
        }
        return this.dataSourcesJSObject;
    }

    public IPreparedCubeQuery prepare(ICubeQueryDefinition query, Map appContext) throws BirtException {
        this.setMemoryUsage(appContext);
        PreparedCubeQueryDefinition preparedQuery = new PreparedCubeQueryDefinition(query);
        return QueryPrepareUtil.prepareQuery(this.cubeDataSourceMap, this.cubeDataObjectMap, this.session, this.context, preparedQuery, appContext);
    }

    public IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        return this.session.getDataSetCacheManager().getCachedResultMetadata(dataSource, dataSet);
    }

    public IEngineExecutionHints getExecutionHints() {
        return this.queryExecutionHints;
    }

    public void registerQueries(IDataQueryDefinition[] queryDefns) throws DataException {
        ((EngineExecutionHints)this.queryExecutionHints).populateCachedDataSets(this, queryDefns);
    }

    public void cancel() {
        this.session.cancel();
    }

    public void restart() {
        this.session.restart();
    }

    public ValidationContext getValidationContext(DataSourceRuntime dataSource, IOdaDataSetDesign dataSet) {
        DataSourceAndDataSetNames key = new DataSourceAndDataSetNames(dataSource.getName(), dataSet.getName());
        if (!this.validationContextMap.containsKey(key)) {
            ExtensionContributor[] contributors = null;
            try {
                contributors = ResultExtensionExplorer.getInstance().getContributorsOfDataSet(dataSource.getExtensionID(), dataSet.getExtensionID());
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            catch (OdaException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            ValidationContext vc = null;
            if (contributors != null && contributors.length > 0) {
                vc = new ValidationContext(contributors[0]);
            }
            this.validationContextMap.put(key, vc);
        }
        return this.validationContextMap.get(key);
    }

    private void releaseValidationContexts() {
        for (ValidationContext vc : this.validationContextMap.values()) {
            if (vc == null || vc.getConnection() == null) continue;
            vc.getConnection().close();
        }
        this.validationContextMap = null;
    }

    public static class DataSourceAndDataSetNames {
        private String dataSourceName;
        private String dataSetName;

        public DataSourceAndDataSetNames(String dataSource, String dataSet) {
            this.dataSourceName = dataSource;
            this.dataSetName = dataSet;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.dataSetName == null ? 0 : this.dataSetName.hashCode());
            result = 31 * result + (this.dataSourceName == null ? 0 : this.dataSourceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataSourceAndDataSetNames other = (DataSourceAndDataSetNames)obj;
            if (this.dataSetName == null ? other.dataSetName != null : !this.dataSetName.equals(other.dataSetName)) {
                return false;
            }
            return !(this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName));
        }
    }
}

